/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class DynamicDataDemo3
extends ApplicationFrame
implements ActionListener {
    public static final int SUBPLOT_COUNT = 3;
    private TimeSeriesCollection[] datasets;
    private double[] lastValue = new double[3];
    static /* synthetic */ Class class$0;

    public DynamicDataDemo3(String title) {
        super(title);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot(new DateAxis("Time"));
        this.datasets = new TimeSeriesCollection[3];
        int i = 0;
        while (i < 3) {
            this.lastValue[i] = 100.0;
            String string = "Random " + i;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.data.time.Millisecond");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TimeSeries series = new TimeSeries(string, clazz);
            this.datasets[i] = new TimeSeriesCollection(series);
            NumberAxis rangeAxis = new NumberAxis("Y" + i);
            rangeAxis.setAutoRangeIncludesZero(false);
            XYPlot subplot = new XYPlot(this.datasets[i], null, rangeAxis, new StandardXYItemRenderer());
            subplot.setBackgroundPaint(Color.lightGray);
            subplot.setDomainGridlinePaint(Color.white);
            subplot.setRangeGridlinePaint(Color.white);
            plot.add(subplot);
            ++i;
        }
        JFreeChart chart = new JFreeChart("Dynamic Data Demo 3", plot);
        chart.getLegend().setAnchor(2);
        chart.setBorderPaint(Color.black);
        chart.setBorderVisible(true);
        chart.setBackgroundPaint(Color.white);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 4.0, 4.0, 4.0, 4.0));
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setFixedAutoRange(60000.0);
        JPanel content = new JPanel(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(chart);
        content.add(chartPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        int i2 = 0;
        while (i2 < 3) {
            JButton button = new JButton("Series " + i2);
            button.setActionCommand("ADD_DATA_" + i2);
            button.addActionListener(this);
            buttonPanel.add(button);
            ++i2;
        }
        JButton buttonAll = new JButton("ALL");
        buttonAll.setActionCommand("ADD_ALL");
        buttonAll.addActionListener(this);
        buttonPanel.add(buttonAll);
        content.add((Component)buttonPanel, "South");
        chartPanel.setPreferredSize(new Dimension(500, 470));
        chartPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(content);
    }

    public void actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < 3) {
            if (e.getActionCommand().endsWith(String.valueOf(i))) {
                Millisecond now = new Millisecond();
                System.out.println("Now = " + now.toString());
                this.lastValue[i] = this.lastValue[i] * (0.9 + 0.2 * Math.random());
                this.datasets[i].getSeries(0).add((RegularTimePeriod)new Millisecond(), this.lastValue[i]);
            }
            ++i;
        }
        if (e.getActionCommand().equals("ADD_ALL")) {
            Millisecond now = new Millisecond();
            System.out.println("Now = " + now.toString());
            int i2 = 0;
            while (i2 < 3) {
                this.lastValue[i2] = this.lastValue[i2] * (0.9 + 0.2 * Math.random());
                this.datasets[i2].getSeries(0).add((RegularTimePeriod)new Millisecond(), this.lastValue[i2]);
                ++i2;
            }
        }
    }

    public static void main(String[] args) {
        DynamicDataDemo3 demo = new DynamicDataDemo3("Dynamic Data Demo 3");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

