/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.time.Day;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class EventFrequencyDemo
extends ApplicationFrame {
    public EventFrequencyDemo(String title) {
        super(title);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Day d1 = new Day(12, 6, 2002);
        Day d2 = new Day(14, 6, 2002);
        Day d3 = new Day(15, 6, 2002);
        Day d4 = new Day(10, 7, 2002);
        Day d5 = new Day(20, 7, 2002);
        Day d6 = new Day(22, 8, 2002);
        dataset.setValue(new Long(d1.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 1"));
        dataset.setValue(new Long(d1.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 2"));
        dataset.setValue(new Long(d2.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 3"));
        dataset.setValue(new Long(d3.getMiddleMillisecond()), (Comparable)((Object)"Series 2"), (Comparable)((Object)"Requirement 1"));
        dataset.setValue(new Long(d4.getMiddleMillisecond()), (Comparable)((Object)"Series 2"), (Comparable)((Object)"Requirement 3"));
        dataset.setValue(new Long(d5.getMiddleMillisecond()), (Comparable)((Object)"Series 3"), (Comparable)((Object)"Requirement 2"));
        dataset.setValue(new Long(d6.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 4"));
        JFreeChart chart = ChartFactory.createBarChart("Event Frequency Demo", "Category", "Value", dataset, PlotOrientation.HORIZONTAL, true, true, false);
        chart.setBackgroundPaint(new Color(255, 255, 204));
        StandardLegend legend = (StandardLegend)chart.getLegend();
        legend.setDisplaySeriesShapes(true);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.getDomainAxis().setMaxCategoryLabelWidthRatio(10.0f);
        plot.setRangeAxis(new DateAxis("Date"));
        StandardCategoryToolTipGenerator toolTipGenerator = new StandardCategoryToolTipGenerator("", DateFormat.getDateInstance());
        LineAndShapeRenderer renderer = new LineAndShapeRenderer(1);
        renderer.setToolTipGenerator(toolTipGenerator);
        plot.setRenderer(renderer);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        EventFrequencyDemo demo = new EventFrequencyDemo("Event Frequency Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

