/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.StackedBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class ExtendedStackedBarRenderer
extends StackedBarRenderer {
    private boolean showPositiveTotal = true;
    private boolean showNegativeTotal = true;
    private Font totalLabelFont = new Font("SansSerif", 0, 10);
    private NumberFormat totalFormatter = NumberFormat.getInstance();

    public NumberFormat getTotalFormatter() {
        return this.totalFormatter;
    }

    public void setTotalFormatter(NumberFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Null format not permitted.");
        }
        this.totalFormatter = format;
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        double total;
        CategoryLabelGenerator generator;
        double translatedValue;
        double translatedBase;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge()) - state.getBarWidth() / 2.0;
        double positiveBase = 0.0;
        double negativeBase = 0.0;
        int i = 0;
        while (i < row) {
            Number v = dataset.getValue(i, column);
            if (v != null) {
                double d = v.doubleValue();
                if (d > 0.0) {
                    positiveBase += d;
                } else {
                    negativeBase += d;
                }
            }
            ++i;
        }
        RectangleEdge location = plot.getRangeAxisEdge();
        if (value > 0.0) {
            translatedBase = rangeAxis.valueToJava2D(positiveBase, dataArea, location);
            translatedValue = rangeAxis.valueToJava2D(positiveBase + value, dataArea, location);
        } else {
            translatedBase = rangeAxis.valueToJava2D(negativeBase, dataArea, location);
            translatedValue = rangeAxis.valueToJava2D(negativeBase + value, dataArea, location);
        }
        double barL0 = Math.min(translatedBase, translatedValue);
        double barLength = Math.max(Math.abs(translatedValue - translatedBase), this.getMinimumBarLength());
        Rectangle2D.Double bar = null;
        bar = orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(barL0, barW0, barLength, state.getBarWidth()) : new Rectangle2D.Double(barW0, barL0, state.getBarWidth(), barLength);
        Paint seriesPaint = this.getItemPaint(row, column);
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            g2.setStroke(this.getItemStroke(row, column));
            g2.setPaint(this.getItemOutlinePaint(row, column));
            g2.draw(bar);
        }
        if ((generator = this.getLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, generator, bar, value < 0.0);
        }
        if (value > 0.0) {
            if (this.showPositiveTotal && this.isLastPositiveItem(dataset, row, column)) {
                g2.setPaint(Color.black);
                g2.setFont(this.totalLabelFont);
                total = this.calculateSumOfPositiveValuesForCategory(dataset, column);
                RefineryUtilities.drawRotatedString(this.totalFormatter.format(total), g2, (float)bar.getCenterX(), (float)(bar.getMinY() - 4.0), TextAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, 0.0);
            }
        } else if (this.showNegativeTotal && this.isLastNegativeItem(dataset, row, column)) {
            g2.setPaint(Color.black);
            g2.setFont(this.totalLabelFont);
            total = this.calculateSumOfNegativeValuesForCategory(dataset, column);
            RefineryUtilities.drawRotatedString(String.valueOf(total), g2, (float)bar.getCenterX(), (float)(bar.getMaxY() + 4.0), TextAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, 0.0);
        }
        if (state.getInfo() != null && (entities = state.getInfo().getOwner().getEntityCollection()) != null) {
            String tip = null;
            CategoryToolTipGenerator tipster = this.getToolTipGenerator(row, column);
            if (tipster != null) {
                tip = tipster.generateToolTip(dataset, row, column);
            }
            String url = null;
            if (this.getItemURLGenerator(row, column) != null) {
                url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity entity = new CategoryItemEntity(bar, tip, url, dataset, row, dataset.getColumnKey(column), column);
            entities.addEntity(entity);
        }
    }

    private boolean isLastPositiveItem(CategoryDataset dataset, int row, int column) {
        boolean result = true;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return false;
        }
        int r = row + 1;
        while (r < dataset.getRowCount()) {
            dataValue = dataset.getValue(r, column);
            if (dataValue != null) {
                result = result && dataValue.doubleValue() <= 0.0;
            }
            ++r;
        }
        return result;
    }

    private boolean isLastNegativeItem(CategoryDataset dataset, int row, int column) {
        boolean result = true;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return false;
        }
        int r = row + 1;
        while (r < dataset.getRowCount()) {
            dataValue = dataset.getValue(r, column);
            if (dataValue != null) {
                result = result && dataValue.doubleValue() >= 0.0;
            }
            ++r;
        }
        return result;
    }

    private double calculateSumOfPositiveValuesForCategory(CategoryDataset dataset, int column) {
        double result = 0.0;
        int r = 0;
        while (r < dataset.getRowCount()) {
            double v;
            Number dataValue = dataset.getValue(r, column);
            if (dataValue != null && (v = dataValue.doubleValue()) > 0.0) {
                result += v;
            }
            ++r;
        }
        return result;
    }

    private double calculateSumOfNegativeValuesForCategory(CategoryDataset dataset, int column) {
        double result = 0.0;
        int r = 0;
        while (r < dataset.getRowCount()) {
            double v;
            Number dataValue = dataset.getValue(r, column);
            if (dataValue != null && (v = dataValue.doubleValue()) < 0.0) {
                result += v;
            }
            ++r;
        }
        return result;
    }
}

