/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.RenderingHints;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class FastScatterPlotDemo
extends ApplicationFrame {
    private static final int COUNT = 500000;
    private float[][] data = new float[2][500000];

    public FastScatterPlotDemo(String title) {
        super(title);
        this.populateData();
        NumberAxis domainAxis = new NumberAxis("X");
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis("Y");
        rangeAxis.setAutoRangeIncludesZero(false);
        FastScatterPlot plot = new FastScatterPlot(this.data, domainAxis, rangeAxis);
        JFreeChart chart = new JFreeChart("Fast Scatter Plot", plot);
        chart.setLegend(null);
        chart.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartPanel panel = new ChartPanel(chart, true);
        panel.setPreferredSize(new Dimension(500, 270));
        panel.setHorizontalZoom(true);
        panel.setVerticalZoom(true);
        panel.setMinimumDrawHeight(10);
        panel.setMaximumDrawHeight(2000);
        panel.setMinimumDrawWidth(20);
        panel.setMaximumDrawWidth(2000);
        this.setContentPane(panel);
    }

    private void populateData() {
        int i = 0;
        while (i < this.data[0].length) {
            float x;
            this.data[0][i] = x = (float)i + 100000.0f;
            this.data[1][i] = 100000.0f + (float)Math.random() * 500000.0f;
            ++i;
        }
    }

    public static void main(String[] args) {
        FastScatterPlotDemo demo = new FastScatterPlotDemo("Fast Scatter Plot Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

