/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class GanttDemo2
extends ApplicationFrame {
    public GanttDemo2(String title) {
        super(title);
        IntervalCategoryDataset dataset = this.createSampleDataset();
        JFreeChart chart = ChartFactory.createGanttChart("Gantt Chart Demo", "Task", "Date", dataset, true, true, false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.getDomainAxis().setMaxCategoryLabelWidthRatio(10.0f);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, Color.blue);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private IntervalCategoryDataset createSampleDataset() {
        TaskSeries s1 = new TaskSeries("Scheduled");
        Task t1 = new Task("Write Proposal", GanttDemo2.date(1, 3, 2001), GanttDemo2.date(5, 3, 2001));
        t1.setPercentComplete(1.0);
        s1.add(t1);
        Task t2 = new Task("Obtain Approval", GanttDemo2.date(9, 3, 2001), GanttDemo2.date(9, 3, 2001));
        t2.setPercentComplete(1.0);
        s1.add(t2);
        Task t3 = new Task("Requirements Analysis", GanttDemo2.date(10, 3, 2001), GanttDemo2.date(5, 4, 2001));
        Task st31 = new Task("Requirements 1", GanttDemo2.date(10, 3, 2001), GanttDemo2.date(25, 3, 2001));
        st31.setPercentComplete(1.0);
        Task st32 = new Task("Requirements 2", GanttDemo2.date(1, 4, 2001), GanttDemo2.date(5, 4, 2001));
        st32.setPercentComplete(1.0);
        t3.addSubtask(st31);
        t3.addSubtask(st32);
        s1.add(t3);
        Task t4 = new Task("Design Phase", GanttDemo2.date(6, 4, 2001), GanttDemo2.date(30, 4, 2001));
        Task st41 = new Task("Design 1", GanttDemo2.date(6, 4, 2001), GanttDemo2.date(10, 4, 2001));
        st41.setPercentComplete(1.0);
        Task st42 = new Task("Design 2", GanttDemo2.date(15, 4, 2001), GanttDemo2.date(20, 4, 2001));
        st42.setPercentComplete(1.0);
        Task st43 = new Task("Design 3", GanttDemo2.date(23, 4, 2001), GanttDemo2.date(30, 4, 2001));
        st43.setPercentComplete(0.5);
        t4.addSubtask(st41);
        t4.addSubtask(st42);
        t4.addSubtask(st43);
        s1.add(t4);
        Task t5 = new Task("Design Signoff", GanttDemo2.date(2, 5, 2001), GanttDemo2.date(2, 5, 2001));
        s1.add(t5);
        Task t6 = new Task("Alpha Implementation", GanttDemo2.date(3, 5, 2001), GanttDemo2.date(31, 6, 2001));
        t6.setPercentComplete(0.6);
        s1.add(t6);
        Task t7 = new Task("Design Review", GanttDemo2.date(1, 7, 2001), GanttDemo2.date(8, 7, 2001));
        t7.setPercentComplete(0.0);
        s1.add(t7);
        Task t8 = new Task("Revised Design Signoff", GanttDemo2.date(10, 7, 2001), GanttDemo2.date(10, 7, 2001));
        t8.setPercentComplete(0.0);
        s1.add(t8);
        Task t9 = new Task("Beta Implementation", GanttDemo2.date(12, 7, 2001), GanttDemo2.date(12, 8, 2001));
        t9.setPercentComplete(0.0);
        s1.add(t9);
        Task t10 = new Task("Testing", GanttDemo2.date(13, 8, 2001), GanttDemo2.date(31, 9, 2001));
        t10.setPercentComplete(0.0);
        s1.add(t10);
        Task t11 = new Task("Final Implementation", GanttDemo2.date(1, 10, 2001), GanttDemo2.date(15, 10, 2001));
        t11.setPercentComplete(0.0);
        s1.add(t11);
        Task t12 = new Task("Signoff", GanttDemo2.date(28, 10, 2001), GanttDemo2.date(30, 10, 2001));
        t12.setPercentComplete(0.0);
        s1.add(t12);
        TaskSeriesCollection collection = new TaskSeriesCollection();
        collection.add(s1);
        return collection;
    }

    private static Date date(int day, int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }

    public static void main(String[] args) {
        GanttDemo2 demo = new GanttDemo2("Gantt Chart Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

