/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HideSeriesDemo
extends ApplicationFrame
implements ActionListener {
    private XYItemRenderer renderer;

    public HideSeriesDemo(String title) {
        super(title);
        XYDataset dataset = this.createSampleDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        JPanel boxPanel = new JPanel();
        JCheckBox box1 = new JCheckBox("Series 1");
        box1.setActionCommand("S1");
        box1.addActionListener(this);
        box1.setSelected(true);
        JCheckBox box2 = new JCheckBox("Series 2");
        box2.setActionCommand("S2");
        box2.addActionListener(this);
        box2.setSelected(true);
        JCheckBox box3 = new JCheckBox("Series 3");
        box3.setActionCommand("S3");
        box3.addActionListener(this);
        box3.setSelected(true);
        boxPanel.add(box1);
        boxPanel.add(box2);
        boxPanel.add(box3);
        JPanel content = new JPanel(new BorderLayout());
        content.add(chartPanel);
        content.add((Component)boxPanel, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(content);
    }

    private XYDataset createSampleDataset() {
        XYSeries series1 = new XYSeries("Series 1");
        series1.add(1.0, 3.3);
        series1.add(2.0, 4.4);
        series1.add(3.0, 1.7);
        XYSeries series2 = new XYSeries("Series 2");
        series2.add(1.0, 7.3);
        series2.add(2.0, 6.8);
        series2.add(3.0, 9.6);
        series2.add(4.0, 5.6);
        XYSeries series3 = new XYSeries("Series 3");
        series3.add(1.0, 17.3);
        series3.add(2.0, 16.8);
        series3.add(3.0, 19.6);
        series3.add(4.0, 15.6);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        dataset.addSeries(series3);
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart result = ChartFactory.createXYLineChart("Hide Series Demo", "X", "Y", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = result.getXYPlot();
        this.renderer = plot.getRenderer(0);
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        int series = -1;
        if (e.getActionCommand().equals("S1")) {
            series = 0;
        } else if (e.getActionCommand().equals("S2")) {
            series = 1;
        } else if (e.getActionCommand().equals("S3")) {
            series = 2;
        }
        if (series >= 0) {
            boolean visible = this.renderer.getItemVisible(series, 0);
            this.renderer.setSeriesVisible(series, new Boolean(!visible));
        }
    }

    public static void main(String[] args) {
        HideSeriesDemo demo = new HideSeriesDemo("Hide Series Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

