/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.HighLowDataset;
import org.jfree.data.MovingAverage;
import org.jfree.data.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HighLowChartDemo2
extends ApplicationFrame {
    public HighLowChartDemo2(String title) {
        super(title);
        HighLowDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private HighLowDataset createDataset() {
        return DemoDatasetFactory.createHighLowDataset();
    }

    private JFreeChart createChart(HighLowDataset dataset) {
        JFreeChart chart = ChartFactory.createHighLowChart("OHLC Demo 2", "Time", "Value", dataset, true);
        DateAxis axis = (DateAxis)chart.getXYPlot().getDomainAxis();
        axis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        XYDataset dataset2 = MovingAverage.createMovingAverage((XYDataset)dataset, "-MAVG", 259200000L, 0L);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDataset(1, dataset2);
        plot.setRenderer(1, new StandardXYItemRenderer());
        return chart;
    }

    public static void main(String[] args) {
        HighLowChartDemo2 demo = new HighLowChartDemo2("OHLC Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

