/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Random;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HistogramDemo
extends ApplicationFrame {
    static Random random = new Random();

    public HistogramDemo(String title) {
        super(title);
        IntervalXYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private IntervalXYDataset createDataset() {
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        dataset.addSeries("H1", HistogramDemo.gaussianData(1000, 3.0), 20);
        dataset.addSeries("H0", HistogramDemo.gaussianData(1000, 0.0), 20);
        return dataset;
    }

    private JFreeChart createChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createHistogram("Histogram Demo", null, null, dataset, PlotOrientation.VERTICAL, true, false, false);
        chart.getXYPlot().setForegroundAlpha(0.75f);
        return chart;
    }

    private static double[] gaussianData(int size, double shift) {
        double[] d = new double[size];
        int i = 0;
        while (i < d.length) {
            d[i] = random.nextGaussian() + shift;
            ++i;
        }
        return d;
    }

    public static void main(String[] args) throws IOException {
        HistogramDemo demo = new HistogramDemo("Histogram Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

