/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.DefaultPieDataset;

public class ImageMapDemo2 {
    public static void main(String[] args) {
        DefaultPieDataset data = new DefaultPieDataset();
        data.setValue((Comparable)((Object)"One"), new Double(43.2));
        data.setValue((Comparable)((Object)"Two"), new Double(10.0));
        data.setValue((Comparable)((Object)"Three"), new Double(27.5));
        data.setValue((Comparable)((Object)"Four"), new Double(17.5));
        data.setValue((Comparable)((Object)"Five"), new Double(11.0));
        data.setValue((Comparable)((Object)"Six"), new Double(19.4));
        JFreeChart chart = null;
        boolean drilldown = true;
        PiePlot plot = new PiePlot(data);
        plot.setInsets(new Insets(0, 5, 5, 5));
        plot.setToolTipGenerator(new StandardPieItemLabelGenerator());
        plot.setURLGenerator(new StandardPieURLGenerator("pie_chart_detail.jsp"));
        chart = new JFreeChart("Pie Chart Demo 1", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        chart.setBackgroundPaint(Color.white);
        try {
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            File file1 = new File("piechart100.png");
            ChartUtilities.saveChartAsPNG(file1, chart, 600, 400, info);
            File file2 = new File("piechart100.html");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter writer = new PrintWriter(out);
            writer.println("<HTML>");
            writer.println("<HEAD><TITLE>JFreeChart Image Map Demo 2</TITLE></HEAD>");
            writer.println("<BODY>");
            ChartUtilities.writeImageMap(writer, "chart", info);
            writer.println("<IMG SRC=\"piechart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            writer.println("</BODY>");
            writer.println("</HTML>");
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }
}

