/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class ImageMapDemo3 {
    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        XYSeries dataSeries = new XYSeries("Curve data");
        ArrayList<String> toolTips = new ArrayList<String>();
        dataSeries.add((double)sdf.parse("01-Jul-2002").getTime(), 5.22);
        toolTips.add("1D - 5.22");
        dataSeries.add((double)sdf.parse("02-Jul-2002").getTime(), 5.18);
        toolTips.add("2D - 5.18");
        dataSeries.add((double)sdf.parse("03-Jul-2002").getTime(), 5.23);
        toolTips.add("3D - 5.23");
        dataSeries.add((double)sdf.parse("04-Jul-2002").getTime(), 5.15);
        toolTips.add("4D - 5.15");
        dataSeries.add((double)sdf.parse("05-Jul-2002").getTime(), 5.22);
        toolTips.add("5D - 5.22");
        dataSeries.add((double)sdf.parse("06-Jul-2002").getTime(), 5.25);
        toolTips.add("6D - 5.25");
        dataSeries.add((double)sdf.parse("07-Jul-2002").getTime(), 5.31);
        toolTips.add("7D - 5.31");
        dataSeries.add((double)sdf.parse("08-Jul-2002").getTime(), 5.36);
        toolTips.add("8D - 5.36");
        XYSeriesCollection xyDataset = new XYSeriesCollection(dataSeries);
        CustomXYToolTipGenerator ttg = new CustomXYToolTipGenerator();
        ttg.addToolTipSeries(toolTips);
        StandardXYURLGenerator urlg = new StandardXYURLGenerator("xy_details.jsp");
        DateAxis timeAxis = new DateAxis("");
        NumberAxis valueAxis = new NumberAxis("");
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(xyDataset, timeAxis, valueAxis, null);
        StandardXYItemRenderer sxyir = new StandardXYItemRenderer(3, ttg, urlg);
        sxyir.setShapesFilled(true);
        plot.setRenderer(sxyir);
        JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        chart.setBackgroundPaint(Color.white);
        try {
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            File file1 = new File("xychart100.png");
            ChartUtilities.saveChartAsPNG(file1, chart, 600, 400, info);
            File file2 = new File("xychart100.html");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter writer = new PrintWriter(out);
            writer.println("<HTML>");
            writer.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            writer.println("<BODY>");
            ChartUtilities.writeImageMap(writer, "chart", info);
            writer.println("<IMG SRC=\"xychart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            writer.println("</BODY>");
            writer.println("</HTML>");
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }
}

