/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;
import org.jfree.ui.VerticalAlignment;

public class ImageMapDemo5 {
    public void saveImageAndHTML() {
        double[][] data = new double[][]{{56.0, -12.0, 34.0, 76.0, 56.0, 100.0, 67.0, 45.0}, {37.0, 45.0, 67.0, 25.0, 34.0, 34.0, 100.0, 53.0}, {43.0, 54.0, 34.0, 34.0, 87.0, 64.0, 73.0, 12.0}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("Series ", "Type ", (double[][])data);
        JFreeChart chart = this.createChart(dataset);
        try {
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            File file1 = new File("areachart100.png");
            ChartUtilities.saveChartAsPNG(file1, chart, 600, 400, info);
            File file2 = new File("areachart100.html");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter writer = new PrintWriter(out);
            writer.println("<HTML>");
            writer.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            writer.println("<BODY>");
            ChartUtilities.writeImageMap(writer, "chart", info);
            writer.println("<IMG SRC=\"areachart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            writer.println("</BODY>");
            writer.println("</HTML>");
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createAreaChart("Area Chart", "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        StandardLegend legend = (StandardLegend)chart.getLegend();
        legend.setAnchor(3);
        chart.setBackgroundPaint(Color.white);
        TextTitle subtitle = new TextTitle("An area chart demonstration.  We use this subtitle  as an example of what happens when you get a really long title or subtitle.");
        subtitle.setFont(new Font("SansSerif", 0, 12));
        subtitle.setPosition(RectangleEdge.TOP);
        subtitle.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.05));
        subtitle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        chart.addSubtitle(subtitle);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.5f);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint(Color.white);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLabelAngle(0.0);
        return chart;
    }

    public static void main(String[] args) {
        ImageMapDemo5 demo = new ImageMapDemo5();
        demo.saveImageAndHTML();
    }
}

