/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.util.TableOrder;

public class ImageMapDemo6 {
    public void saveImageAndHTML() {
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        try {
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            File file1 = new File("multipiechart100.png");
            ChartUtilities.saveChartAsPNG(file1, chart, 600, 400, info);
            File file2 = new File("multipiechart100.html");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter writer = new PrintWriter(out);
            writer.println("<HTML>");
            writer.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            writer.println("<BODY>");
            ChartUtilities.writeImageMap(writer, "chart", info);
            writer.println("<IMG SRC=\"multipiechart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            writer.println("</BODY>");
            writer.println("</HTML>");
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{3.0, 4.0, 3.0, 5.0}, {5.0, 7.0, 6.0, 8.0}, {5.0, 7.0, 3.0, 8.0}, {1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 2.0, 3.0}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("Region ", "Sales/Q", (double[][])data);
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createMultiplePieChart("Multiple Pie Chart", dataset, TableOrder.BY_ROW, true, true, true);
        MultiplePiePlot plot = (MultiplePiePlot)chart.getPlot();
        JFreeChart subchart = plot.getPieChart();
        PiePlot p = (PiePlot)subchart.getPlot();
        p.setLabelGenerator(new StandardPieItemLabelGenerator("{0}"));
        p.setLabelFont(new Font("SansSerif", 0, 8));
        p.setInteriorGap(0.3);
        return chart;
    }

    public static void main(String[] args) {
        ImageMapDemo6 demo = new ImageMapDemo6();
        demo.saveImageAndHTML();
    }
}

