/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class InternalFrameDemo
extends ApplicationFrame {
    public InternalFrameDemo(String title) {
        super(title);
        JDesktopPane desktopPane = new JDesktopPane();
        desktopPane.setPreferredSize(new Dimension(600, 400));
        JInternalFrame frame1 = this.createFrame1();
        desktopPane.add(frame1);
        frame1.pack();
        frame1.setVisible(true);
        JInternalFrame frame2 = this.createFrame2();
        desktopPane.add(frame2);
        frame2.pack();
        frame2.setLocation(100, 200);
        frame2.setVisible(true);
        this.getContentPane().add(desktopPane);
    }

    private JInternalFrame createFrame1() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(34.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        dataset.addValue(23.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        dataset.addValue(54.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 3"));
        JFreeChart chart = ChartFactory.createBarChart("Bar Chart", "Category", "Series", dataset, PlotOrientation.VERTICAL, true, true, false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(200, 100));
        JInternalFrame frame = new JInternalFrame("Frame 1", true);
        frame.getContentPane().add(chartPanel);
        return frame;
    }

    private JInternalFrame createFrame2() {
        XYDataset dataset1 = this.createDataset("Series 1", 100.0, new Minute(), 200);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Time Series Chart", "Time of Day", "Value", dataset1, true, true, false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(200, 100));
        JInternalFrame frame = new JInternalFrame("Frame 2", true);
        frame.getContentPane().add(chartPanel);
        return frame;
    }

    private XYDataset createDataset(String name, double base, RegularTimePeriod start, int count) {
        TimeSeries series = new TimeSeries(name, start.getClass());
        RegularTimePeriod period = start;
        double value = base;
        int i = 0;
        while (i < count) {
            series.add(period, value);
            period = period.next();
            value *= 1.0 + (Math.random() - 0.495) / 10.0;
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public static void main(String[] args) {
        InternalFrameDemo demo = new InternalFrameDemo("Internal Frame Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

