/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.IntervalCategoryLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.IntervalBarRenderer;
import org.jfree.data.DefaultIntervalCategoryDataset;
import org.jfree.ui.TextAnchor;

public class IntervalBarChartDemo1 {
    private static final String[] CATEGORIES = new String[]{"1", "3", "5", "10", "20"};
    private static Font labelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    static {
        labelFont = new Font("Helvetica", 0, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }

    public IntervalBarChartDemo1() {
        DefaultIntervalCategoryDataset data = null;
        double[][] lows = new double[][]{{-0.0315, 0.0159, 0.0306, 0.0453, 0.0557}};
        double[][] highs = new double[][]{{0.1931, 0.1457, 0.131, 0.1163, 0.1059}};
        data = new DefaultIntervalCategoryDataset(lows, highs);
        data.setCategoryKeys((Comparable[])CATEGORIES);
        String title = "Strategie Sicherheit";
        String xTitle = "Zeitraum (in Jahren)";
        String yTitle = "Performance";
        CategoryAxis xAxis = new CategoryAxis("Zeitraum (in Jahren)");
        xAxis.setLabelFont(titleFont);
        xAxis.setTickLabelFont(labelFont);
        xAxis.setTickMarksVisible(false);
        NumberAxis yAxis = new NumberAxis("Performance");
        yAxis.setLabelFont(titleFont);
        yAxis.setTickLabelFont(labelFont);
        yAxis.setRange(-0.2, 0.4);
        DecimalFormat formatter = new DecimalFormat("0.##%");
        yAxis.setTickUnit(new NumberTickUnit(0.05, formatter));
        IntervalBarRenderer renderer = new IntervalBarRenderer();
        renderer.setSeriesPaint(0, new Color(51, 102, 153));
        renderer.setLabelGenerator(new IntervalCategoryLabelGenerator());
        renderer.setItemLabelsVisible(true);
        renderer.setItemLabelPaint(Color.white);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        renderer.setPositiveItemLabelPosition(p);
        CategoryPlot plot = new CategoryPlot(data, xAxis, yAxis, renderer);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setOutlinePaint(Color.white);
        plot.setOrientation(PlotOrientation.VERTICAL);
        this.chart = new JFreeChart("Strategie Sicherheit", titleFont, plot, false);
        this.chart.setBackgroundPaint(Color.white);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public static void main(String[] args) {
        IntervalBarChartDemo1 sample = new IntervalBarChartDemo1();
        JFreeChart chart = sample.getChart();
        ChartFrame frame = new ChartFrame("Interval Bar Chart Demo", chart);
        frame.pack();
        frame.setVisible(true);
    }
}

