/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ItemLabelDemo1
extends ApplicationFrame {
    public ItemLabelDemo1(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(11.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C1"));
        dataset.addValue(44.3, (Comparable)((Object)"S1"), (Comparable)((Object)"C2"));
        dataset.addValue(93.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C3"));
        dataset.addValue(35.6, (Comparable)((Object)"S1"), (Comparable)((Object)"C4"));
        dataset.addValue(75.1, (Comparable)((Object)"S1"), (Comparable)((Object)"C5"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart("Item Label Demo 1", "Category", "Value", dataset, PlotOrientation.VERTICAL, false, true, false);
        chart.setBackgroundPaint(Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setUpperMargin(0.15);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setLabelGenerator(new LabelGenerator(50.0));
        renderer.setItemLabelsVisible(true);
        return chart;
    }

    public static void main(String[] args) {
        ItemLabelDemo1 demo = new ItemLabelDemo1("Item Label Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }

    static class LabelGenerator
    implements CategoryLabelGenerator {
        private double threshold;

        public LabelGenerator(double threshold) {
            this.threshold = threshold;
        }

        public String generateLabel(CategoryDataset dataset, int series, int category) {
            double v;
            String result = null;
            Number value = dataset.getValue(series, category);
            if (value != null && (v = value.doubleValue()) > this.threshold) {
                result = value.toString();
            }
            return result;
        }
    }
}

