/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ItemLabelDemo2
extends ApplicationFrame {
    public ItemLabelDemo2(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(100.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C1"));
        dataset.addValue(44.3, (Comparable)((Object)"S1"), (Comparable)((Object)"C2"));
        dataset.addValue(93.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C3"));
        dataset.addValue(80.0, (Comparable)((Object)"S2"), (Comparable)((Object)"C1"));
        dataset.addValue(75.1, (Comparable)((Object)"S2"), (Comparable)((Object)"C2"));
        dataset.addValue(15.1, (Comparable)((Object)"S2"), (Comparable)((Object)"C3"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart("Item Label Demo 2", "Category", "Value", dataset, PlotOrientation.HORIZONTAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setUpperMargin(0.25);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setItemLabelsVisible(true);
        renderer.setLabelGenerator(new LabelGenerator(null));
        return chart;
    }

    public static void main(String[] args) {
        ItemLabelDemo2 demo = new ItemLabelDemo2("Item Label Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }

    static class LabelGenerator
    implements CategoryLabelGenerator {
        private Integer category;
        private NumberFormat formatter = NumberFormat.getPercentInstance();

        public LabelGenerator(int category) {
            this(new Integer(category));
        }

        public LabelGenerator(Integer category) {
            this.category = category;
        }

        public String generateLabel(CategoryDataset dataset, int series, int category) {
            String result = null;
            double base = 0.0;
            if (this.category != null) {
                Number b = dataset.getValue(series, this.category);
                base = b.doubleValue();
            } else {
                base = this.calculateSeriesTotal(dataset, series);
            }
            Number value = dataset.getValue(series, category);
            if (value != null) {
                double v = value.doubleValue();
                result = String.valueOf(value.toString()) + " (" + this.formatter.format(v / base) + ")";
            }
            return result;
        }

        private double calculateSeriesTotal(CategoryDataset dataset, int series) {
            double result = 0.0;
            int i = 0;
            while (i < dataset.getColumnCount()) {
                Number value = dataset.getValue(series, i);
                if (value != null) {
                    result += value.doubleValue();
                }
                ++i;
            }
            return result;
        }
    }
}

