/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DescriptionPanel;
import org.jfree.chart.demo.JFreeChartDemoBase;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.about.AboutFrame;

public class JFreeChartDemo
extends JFrame
implements ActionListener,
WindowListener {
    public static final String EXIT_COMMAND = "EXIT";
    public static final String ABOUT_COMMAND = "ABOUT";
    private static final JFreeChartDemoBase DEMO = new JFreeChartDemoBase();
    private static final String[][] CHART_COMMANDS = JFreeChartDemoBase.CHART_COMMANDS;
    private ResourceBundle resources;
    private ChartFrame[] frame = new ChartFrame[CHART_COMMANDS.length];
    private JPanel[] panels = null;
    public static final Dimension PREFERRED_SIZE = new Dimension(780, 400);
    private AboutFrame aboutFrame;

    public JFreeChartDemo() {
        super(String.valueOf(JFreeChart.INFO.getName()) + " " + JFreeChart.INFO.getVersion() + " Demo");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFreeChartDemo.this.dispose();
                System.exit(0);
            }
        });
        this.resources = DEMO.getResources();
        JMenuBar menuBar = this.createMenuBar(this.resources);
        this.setJMenuBar(menuBar);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createTabbedPane(this.resources));
        this.setContentPane(content);
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(EXIT_COMMAND)) {
            this.attemptExit();
        } else if (command.equals(ABOUT_COMMAND)) {
            this.about();
        } else {
            int chartnum = -1;
            int i = CHART_COMMANDS.length;
            while (i > 0) {
                if (!command.equals(CHART_COMMANDS[--i][0])) continue;
                chartnum = i;
                i = 0;
            }
            if (chartnum >= 0 && chartnum < this.frame.length) {
                if (this.frame[chartnum] == null) {
                    block11: {
                        DEMO.getChart(chartnum);
                        String str = this.resources.getString(String.valueOf(CHART_COMMANDS[chartnum][2]) + ".title");
                        this.frame[chartnum] = new ChartFrame(str, DEMO.getChart(chartnum));
                        this.frame[chartnum].getChartPanel().setPreferredSize(new Dimension(500, 270));
                        this.frame[chartnum].pack();
                        RefineryUtilities.positionFrameRandomly(this.frame[chartnum]);
                        try {
                            str = this.resources.getString(String.valueOf(CHART_COMMANDS[chartnum][2]) + ".zoom");
                            if (str != null && str.toLowerCase().equals("true")) {
                                ChartPanel panel = this.frame[chartnum].getChartPanel();
                                panel.setMouseZoomable(true);
                                panel.setHorizontalAxisTrace(true);
                                panel.setVerticalAxisTrace(true);
                            }
                        }
                        catch (Exception ex) {
                            if (ex.getMessage().indexOf("MissingResourceException") != 0) break block11;
                            ex.printStackTrace();
                        }
                    }
                    this.frame[chartnum].setVisible(true);
                } else {
                    this.frame[chartnum].setVisible(true);
                    this.frame[chartnum].requestFocus();
                }
            }
        }
    }

    private void attemptExit() {
        String title = this.resources.getString("dialog.exit.title");
        String message = this.resources.getString("dialog.exit.message");
        int result = JOptionPane.showConfirmDialog(this, message, title, 0, 3);
        if (result == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    private void about() {
        String title = this.resources.getString("about.title");
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutFrame(title, JFreeChart.INFO);
            this.aboutFrame.pack();
            RefineryUtilities.centerFrameOnScreen(this.aboutFrame);
        }
        this.aboutFrame.setVisible(true);
        this.aboutFrame.requestFocus();
    }

    public static void main(String[] args) {
        JFreeChartDemo f = new JFreeChartDemo();
        f.pack();
        RefineryUtilities.centerFrameOnScreen(f);
        f.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (e.getWindow() == this.aboutFrame) {
            this.aboutFrame = null;
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private JMenuBar createMenuBar(ResourceBundle resources) {
        JMenuBar menuBar = new JMenuBar();
        String label = resources.getString("menu.file");
        Character mnemonic = (Character)resources.getObject("menu.file.mnemonic");
        JMenu fileMenu = new JMenu(label, true);
        fileMenu.setMnemonic(mnemonic.charValue());
        label = resources.getString("menu.file.exit");
        mnemonic = (Character)resources.getObject("menu.file.exit.mnemonic");
        JMenuItem exitItem = new JMenuItem(label, mnemonic.charValue());
        exitItem.setActionCommand(EXIT_COMMAND);
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        label = resources.getString("menu.help");
        mnemonic = (Character)resources.getObject("menu.help.mnemonic");
        JMenu helpMenu = new JMenu(label);
        helpMenu.setMnemonic(mnemonic.charValue());
        label = resources.getString("menu.help.about");
        mnemonic = (Character)resources.getObject("menu.help.about.mnemonic");
        JMenuItem aboutItem = new JMenuItem(label, mnemonic.charValue());
        aboutItem.setActionCommand(ABOUT_COMMAND);
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JTabbedPane createTabbedPane(ResourceBundle resources) {
        Font font = new Font("Dialog", 0, 12);
        JTabbedPane tabs = new JTabbedPane();
        int tab = 1;
        Vector<String> titles = new Vector<String>(0);
        String title = null;
        while (tab > 0) {
            try {
                title = resources.getString("tabs." + tab);
                if (title != null) {
                    titles.add(title);
                } else {
                    tab = -1;
                }
                ++tab;
            }
            catch (Exception ex) {
                tab = -1;
            }
        }
        if (titles.size() == 0) {
            titles.add("Default");
        }
        tab = titles.size();
        this.panels = new JPanel[tab];
        String[] tabTitles = new String[tab];
        --tab;
        while (tab >= 0) {
            tabTitles[tab] = title = titles.get(tab).toString();
            --tab;
        }
        titles.removeAllElements();
        int i = 0;
        while (i < tabTitles.length) {
            this.panels[i] = new JPanel();
            this.panels[i].setLayout(new LCBLayout(20));
            this.panels[i].setPreferredSize(new Dimension(360, 20));
            this.panels[i].setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            tabs.add(tabTitles[i], new JScrollPane(this.panels[i]));
            ++i;
        }
        String buttonText = resources.getString("charts.display");
        String usage = null;
        int i2 = 0;
        while (i2 <= CHART_COMMANDS.length - 1) {
            try {
                usage = resources.getString(String.valueOf(CHART_COMMANDS[i2][2]) + ".usage");
            }
            catch (Exception ex) {
                usage = null;
            }
            if (usage == null || usage.equalsIgnoreCase("All") || usage.equalsIgnoreCase("Swing")) {
                title = resources.getString(String.valueOf(CHART_COMMANDS[i2][2]) + ".title");
                String description = resources.getString(String.valueOf(CHART_COMMANDS[i2][2]) + ".description");
                try {
                    tab = Integer.parseInt(resources.getString(String.valueOf(CHART_COMMANDS[i2][2]) + ".tab"));
                    --tab;
                }
                catch (Exception ex) {
                    System.err.println("Demo : Error retrieving tab identifier for chart " + CHART_COMMANDS[i2][2]);
                    System.err.println("Demo : Error = " + ex.getMessage());
                    tab = 0;
                }
                if (tab < 0 || tab >= this.panels.length) {
                    tab = 0;
                }
                System.out.println("Demo : adding " + CHART_COMMANDS[i2][0] + " to panel " + tab);
                this.panels[tab].add(RefineryUtilities.createJLabel(title, font));
                this.panels[tab].add(new DescriptionPanel(new JTextArea(description)));
                JButton b1 = RefineryUtilities.createJButton(buttonText, font);
                b1.setActionCommand(CHART_COMMANDS[i2][0]);
                b1.addActionListener(this);
                this.panels[tab].add(b1);
            }
            ++i2;
        }
        return tabs;
    }
}

