/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.demo.EmptyXYDataset;
import org.jfree.chart.demo.SampleXYDataset;
import org.jfree.chart.demo.SampleXYDataset2;
import org.jfree.chart.demo.SampleXYDatasetThread;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.WaferMapPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.HighLowRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.WaferMapRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.CombinedDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.MovingAverage;
import org.jfree.data.PieDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SignalsDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.WaferMapDataset;
import org.jfree.data.WindDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;

public class JFreeChartDemoBase {
    public static final String[][] CHART_COMMANDS = new String[][]{{"HORIZONTAL_BAR_CHART", "createHorizontalBarChart", "chart1"}, {"HORIZONTAL_STACKED_BAR_CHART", "createStackedHorizontalBarChart", "chart2"}, {"VERTICAL_BAR_CHART", "createVerticalBarChart", "chart3"}, {"VERTICAL_3D_BAR_CHART", "createVertical3DBarChart", "chart4"}, {"VERTICAL_STACKED_BAR_CHART", "createVerticalStackedBarChart", "chart5"}, {"VERTICAL_STACKED_3D_BAR_CHART", "createVerticalStacked3DBarChart", "chart6"}, {"PIE_CHART_1", "createPieChartOne", "chart7"}, {"PIE_CHART_2", "createPieChartTwo", "chart8"}, {"PIE_CHART_3", "createPieChartThree", "chart39"}, {"XY_PLOT", "createXYPlot", "chart9"}, {"TIME_SERIES_1_CHART", "createTimeSeries1Chart", "chart10"}, {"TIME_SERIES_2_CHART", "createTimeSeries2Chart", "chart11"}, {"TIME_SERIES_WITH_MA_CHART", "createTimeSeriesWithMAChart", "chart12"}, {"HIGH_LOW_CHART", "createHighLowChart", "chart13"}, {"CANDLESTICK_CHART", "createCandlestickChart", "chart14"}, {"SIGNAL_CHART", "createSignalChart", "chart15"}, {"WIND_PLOT", "createWindPlot", "chart16"}, {"SCATTER_PLOT", "createScatterPlot", "chart17"}, {"LINE_CHART", "createLineChart", "chart18"}, {"VERTICAL_XY_BAR_CHART", "createVerticalXYBarChart", "chart19"}, {"XY_PLOT_NULL", "createNullXYPlot", "chart20"}, {"XY_PLOT_ZERO", "createXYPlotZeroData", "chart21"}, {"TIME_SERIES_CHART_SCROLL", "createTimeSeriesChartInScrollPane", "chart22"}, {"SINGLE_SERIES_BAR_CHART", "createSingleSeriesBarChart", "chart23"}, {"DYNAMIC_CHART", "createDynamicXYChart", "chart24"}, {"OVERLAID_CHART", "createOverlaidChart", "chart25"}, {"HORIZONTALLY_COMBINED_CHART", "createHorizontallyCombinedChart", "chart26"}, {"VERTICALLY_COMBINED_CHART", "createVerticallyCombinedChart", "chart27"}, {"COMBINED_OVERLAID_CHART", "createCombinedAndOverlaidChart1", "chart28"}, {"COMBINED_OVERLAID_DYNAMIC_CHART", "createCombinedAndOverlaidDynamicXYChart", "chart29"}, {"THERMOMETER_CHART", "createThermometerChart", "chart30"}, {"METER_CHART", "createMeterChartCircle", "chart31"}, {"GANTT_CHART", "createGanttChart", "chart32"}, {"METER_CHART2", "createMeterChartPie", "chart33"}, {"METER_CHART3", "createMeterChartChord", "chart34"}, {"COMPASS_CHART", "createCompassChart", "chart35"}, {"WAFERMAP_CHART", "createWaferMapChart", "chart36"}, {"WAFERMAP_VALUE_CHART", "createWaferMapChartValueIndexed", "chart37"}, {"WAFERMAP_POSITION_CHART", "createWaferMapChartPositionIndexed", "chart38"}};
    public static final String BASE_RESOURCE_CLASS = "org.jfree.chart.demo.resources.DemoResources";
    private ResourceBundle resources;
    private JFreeChart[] charts = new JFreeChart[CHART_COMMANDS.length];

    public JFreeChartDemoBase() {
        this.resources = ResourceBundle.getBundle(BASE_RESOURCE_CLASS);
    }

    public JFreeChart getChart(int i) {
        if (i < 0 && i >= this.charts.length) {
            i = 0;
        }
        if (this.charts[i] == null) {
            try {
                Method method = this.getClass().getDeclaredMethod(CHART_COMMANDS[i][1], null);
                this.charts[i] = (JFreeChart)method.invoke((Object)this, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.charts[i];
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public JFreeChart createHorizontalBarChart() {
        String title = this.resources.getString("bar.horizontal.title");
        String domain = this.resources.getString("bar.horizontal.domain");
        String range = this.resources.getString("bar.horizontal.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart(title, domain, range, data, PlotOrientation.HORIZONTAL, true, true, false);
        chart.getLegend().setAnchor(2);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRangeCrosshairVisible(false);
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        axis.setInverted(true);
        return chart;
    }

    public JFreeChart createStackedHorizontalBarChart() {
        String title = this.resources.getString("bar.horizontal-stacked.title");
        String domain = this.resources.getString("bar.horizontal-stacked.domain");
        String range = this.resources.getString("bar.horizontal-stacked.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart(title, domain, range, data, PlotOrientation.HORIZONTAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        return chart;
    }

    public JFreeChart createVerticalBarChart() {
        String title = this.resources.getString("bar.vertical.title");
        String domain = this.resources.getString("bar.vertical.domain");
        String range = this.resources.getString("bar.vertical.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.9f);
        NumberAxis verticalAxis = (NumberAxis)plot.getRangeAxis();
        verticalAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    public JFreeChart createVertical3DBarChart() {
        String title = this.resources.getString("bar.vertical3D.title");
        String domain = this.resources.getString("bar.vertical3D.domain");
        String range = this.resources.getString("bar.vertical3D.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart3D(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.75f);
        return chart;
    }

    public JFreeChart createVerticalStackedBarChart() {
        String title = this.resources.getString("bar.vertical-stacked.title");
        String domain = this.resources.getString("bar.vertical-stacked.domain");
        String range = this.resources.getString("bar.vertical-stacked.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createVerticalStacked3DBarChart() {
        String title = this.resources.getString("bar.vertical-stacked3D.title");
        String domain = this.resources.getString("bar.vertical-stacked3D.domain");
        String range = this.resources.getString("bar.vertical-stacked3D.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart3D(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createPieChartOne() {
        String title = this.resources.getString("pie.pie1.title");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        PieDataset extracted = DatasetUtilities.createPieDatasetForRow(data, 0);
        JFreeChart chart = ChartFactory.createPieChart(title, extracted, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setCircular(false);
        plot.setExplodePercent(1, 1.0);
        return chart;
    }

    public JFreeChart createPieChartTwo() {
        String title = this.resources.getString("pie.pie2.title");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        Comparable category = (Comparable)data.getColumnKeys().get(1);
        PieDataset extracted = DatasetUtilities.createPieDatasetForColumn(data, category);
        JFreeChart chart = ChartFactory.createPieChart(title, extracted, true, true, false);
        chart.setBackgroundPaint(Color.lightGray);
        PiePlot pie = (PiePlot)chart.getPlot();
        pie.setLabelGenerator(new StandardPieItemLabelGenerator("{0} = {2}", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        pie.setBackgroundImage(JFreeChart.INFO.getLogo());
        pie.setBackgroundPaint(Color.white);
        pie.setBackgroundAlpha(0.6f);
        pie.setForegroundAlpha(0.75f);
        return chart;
    }

    public JFreeChart createPieChartThree() {
        String title = this.resources.getString("pie.pie3.title");
        double[][] data = new double[][]{{10.0, 4.0, 14.0, 12.0, 12.0}, {9.0, 7.0, 13.7, 15.0, 3.0}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])data);
        PieDataset extracted = DatasetUtilities.createPieDatasetForRow(dataset, 0);
        PieDataset extracted2 = DatasetUtilities.createPieDatasetForRow(dataset, 1);
        JFreeChart chart = ChartFactory.createPieChart(title, extracted, extracted2, 40, true, true, true, false, true, true);
        return chart;
    }

    public JFreeChart createXYPlot() {
        String title = this.resources.getString("xyplot.sample1.title");
        String domain = this.resources.getString("xyplot.sample1.domain");
        String range = this.resources.getString("xyplot.sample1.range");
        XYDataset data = DemoDatasetFactory.createSampleXYDataset();
        JFreeChart chart = ChartFactory.createXYLineChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return chart;
    }

    public JFreeChart createTimeSeries1Chart() {
        String title = this.resources.getString("timeseries.sample1.title");
        String subtitle = this.resources.getString("timeseries.sample1.subtitle");
        String domain = this.resources.getString("timeseries.sample1.domain");
        String range = this.resources.getString("timeseries.sample1.range");
        String copyrightStr = this.resources.getString("timeseries.sample1.copyright");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection3();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true, true, false);
        TextTitle title2 = new TextTitle(subtitle, new Font("SansSerif", 0, 12));
        title2.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.0));
        chart.addSubtitle(title2);
        TextTitle copyright = new TextTitle(copyrightStr, new Font("SansSerif", 0, 9));
        copyright.setPosition(RectangleEdge.BOTTOM);
        copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle(copyright);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        XYPlot plot = chart.getXYPlot();
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setVerticalTickLabels(true);
        return chart;
    }

    public JFreeChart createTimeSeries2Chart() {
        String title = this.resources.getString("timeseries.sample2.title");
        String subtitleStr = this.resources.getString("timeseries.sample2.subtitle");
        String domain = this.resources.getString("timeseries.sample2.domain");
        String range = this.resources.getString("timeseries.sample2.range");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection4();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true, true, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        XYPlot plot = chart.getXYPlot();
        LogarithmicAxis rangeAxis = new LogarithmicAxis(range);
        plot.setRangeAxis(rangeAxis);
        return chart;
    }

    public JFreeChart createTimeSeriesWithMAChart() {
        String title = this.resources.getString("timeseries.sample3.title");
        String domain = this.resources.getString("timeseries.sample3.domain");
        String range = this.resources.getString("timeseries.sample3.range");
        String subtitleStr = this.resources.getString("timeseries.sample3.subtitle");
        TimeSeries jpy = DemoDatasetFactory.createJPYTimeSeries();
        TimeSeries mav = MovingAverage.createMovingAverage(jpy, "30 Day Moving Average", 30, 30);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(jpy);
        dataset.addSeries(mav);
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, dataset, true, true, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createHighLowChart() {
        String title = this.resources.getString("timeseries.highlow.title");
        String domain = this.resources.getString("timeseries.highlow.domain");
        String range = this.resources.getString("timeseries.highlow.range");
        String subtitleStr = this.resources.getString("timeseries.highlow.subtitle");
        HighLowDataset data = DemoDatasetFactory.createHighLowDataset();
        JFreeChart chart = ChartFactory.createHighLowChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.magenta));
        return chart;
    }

    public JFreeChart createCandlestickChart() {
        String title = this.resources.getString("timeseries.candlestick.title");
        String domain = this.resources.getString("timeseries.candlestick.domain");
        String range = this.resources.getString("timeseries.candlestick.range");
        String subtitleStr = this.resources.getString("timeseries.candlestick.subtitle");
        HighLowDataset data = DemoDatasetFactory.createHighLowDataset();
        JFreeChart chart = ChartFactory.createCandlestickChart(title, domain, range, data, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return chart;
    }

    public JFreeChart createSignalChart() {
        String title = this.resources.getString("timeseries.signal.title");
        String domain = this.resources.getString("timeseries.signal.domain");
        String range = this.resources.getString("timeseries.signal.range");
        String subtitleStr = this.resources.getString("timeseries.signal.subtitle");
        SignalsDataset data = DemoDatasetFactory.createSampleSignalDataset();
        JFreeChart chart = ChartFactory.createSignalChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createThermometerChart() {
        String title = this.resources.getString("meter.thermo.title");
        String subtitleStr = this.resources.getString("meter.thermo.subtitle");
        String units = this.resources.getString("meter.thermo.units");
        DefaultValueDataset data = new DefaultValueDataset(new Double(34.0));
        ThermometerPlot plot = new ThermometerPlot(data);
        plot.setUnits(units);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createMeterChartCircle() {
        String title = this.resources.getString("meter.meter.title");
        String subtitleStr = this.resources.getString("meter.meter.subtitle");
        DefaultValueDataset data = new DefaultValueDataset(50.0);
        MeterPlot plot = new MeterPlot(data);
        plot.setMeterAngle(270);
        plot.setDialShape(DialShape.CIRCLE);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createMeterChartPie() {
        String title = this.resources.getString("meter.meter.title");
        String subtitleStr = this.resources.getString("meter.meter.subtitle");
        DefaultValueDataset data = new DefaultValueDataset(50.0);
        MeterPlot plot = new MeterPlot(data);
        plot.setMeterAngle(270);
        plot.setDialShape(DialShape.PIE);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createMeterChartChord() {
        String title = this.resources.getString("meter.meter.title");
        String subtitleStr = this.resources.getString("meter.meter.subtitle");
        DefaultValueDataset data = new DefaultValueDataset(45.0);
        MeterPlot plot = new MeterPlot(data);
        plot.setMeterAngle(270);
        plot.setDialShape(DialShape.CHORD);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createCompassChart() {
        String title = this.resources.getString("meter.compass.title");
        String subtitleStr = this.resources.getString("meter.compass.subtitle");
        DefaultValueDataset data = new DefaultValueDataset(new Double(45.0));
        CompassPlot plot = new CompassPlot(data);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createWindPlot() {
        String title = this.resources.getString("other.wind.title");
        String domain = this.resources.getString("other.wind.domain");
        String range = this.resources.getString("other.wind.range");
        WindDataset data = DemoDatasetFactory.createWindDataset1();
        JFreeChart chart = ChartFactory.createWindPlot(title, domain, range, data, true, false, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        return chart;
    }

    public JFreeChart createScatterPlot() {
        String title = this.resources.getString("other.scatter.title");
        String domain = this.resources.getString("other.scatter.domain");
        String range = this.resources.getString("other.scatter.range");
        SampleXYDataset2 data = new SampleXYDataset2();
        JFreeChart chart = ChartFactory.createScatterPlot(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        XYPlot plot = chart.getXYPlot();
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    public JFreeChart createLineChart() {
        String title = this.resources.getString("other.line.title");
        String domain = this.resources.getString("other.line.domain");
        String range = this.resources.getString("other.line.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createLineChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundImage(JFreeChart.INFO.getLogo());
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundAlpha(0.65f);
        return chart;
    }

    public JFreeChart createVerticalXYBarChart() {
        String title = this.resources.getString("other.xybar.title");
        String domain = this.resources.getString("other.xybar.domain");
        String range = this.resources.getString("other.xybar.range");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection1();
        data.setDomainIsPointsInTime(false);
        JFreeChart chart = ChartFactory.createXYBarChart(title, domain, true, range, data, PlotOrientation.VERTICAL, true, false, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        XYItemRenderer renderer = chart.getXYPlot().getRenderer();
        renderer.setToolTipGenerator(StandardXYToolTipGenerator.getTimeSeriesInstance());
        return chart;
    }

    public JFreeChart createNullXYPlot() {
        String title = this.resources.getString("test.null.title");
        String domain = this.resources.getString("test.null.domain");
        String range = this.resources.getString("test.null.range");
        XYDataset data = null;
        JFreeChart chart = ChartFactory.createXYLineChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createXYPlotZeroData() {
        String title = this.resources.getString("test.zero.title");
        String domain = this.resources.getString("test.zero.domain");
        String range = this.resources.getString("test.zero.range");
        EmptyXYDataset data = new EmptyXYDataset();
        JFreeChart chart = ChartFactory.createXYLineChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createTimeSeriesChartInScrollPane() {
        String title = this.resources.getString("test.scroll.title");
        String domain = this.resources.getString("test.scroll.domain");
        String range = this.resources.getString("test.scroll.range");
        String subtitleStr = this.resources.getString("test.scroll.subtitle");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection2();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true, true, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.gray));
        return chart;
    }

    public JFreeChart createSingleSeriesBarChart() {
        String title = this.resources.getString("test.single.title");
        String domain = this.resources.getString("test.single.domain");
        String range = this.resources.getString("test.single.range");
        String subtitle1Str = this.resources.getString("test.single.subtitle1");
        String subtitle2Str = this.resources.getString("test.single.subtitle2");
        CategoryDataset data = DemoDatasetFactory.createSingleSeriesCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart(title, domain, range, data, PlotOrientation.HORIZONTAL, true, true, false);
        chart.addSubtitle(new TextTitle(subtitle1Str));
        chart.addSubtitle(new TextTitle(subtitle2Str));
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createDynamicXYChart() {
        String title = this.resources.getString("test.dynamic.title");
        String domain = this.resources.getString("test.dynamic.domain");
        String range = this.resources.getString("test.dynamic.range");
        SampleXYDataset data = new SampleXYDataset();
        JFreeChart chart = ChartFactory.createXYLineChart(title, domain, range, data, PlotOrientation.VERTICAL, true, true, false);
        SampleXYDatasetThread update = new SampleXYDatasetThread(data);
        Thread thread = new Thread(update);
        thread.start();
        return chart;
    }

    public JFreeChart createOverlaidChart() {
        String title = this.resources.getString("combined.overlaid.title");
        String subtitleStr = this.resources.getString("combined.overlaid.subtitle");
        String domainAxisLabel = this.resources.getString("combined.overlaid.domain");
        String rangeAxisLabel = this.resources.getString("combined.overlaid.range");
        HighLowDataset highLowData = DemoDatasetFactory.createHighLowDataset();
        DateAxis domainAxis = new DateAxis(domainAxisLabel);
        NumberAxis rangeAxis = new NumberAxis(rangeAxisLabel);
        rangeAxis.setAutoRangeIncludesZero(false);
        HighLowRenderer renderer1 = new HighLowRenderer();
        renderer1.setToolTipGenerator(new HighLowItemLabelGenerator());
        XYPlot plot = new XYPlot(highLowData, domainAxis, rangeAxis, renderer1);
        XYDataset maData = MovingAverage.createMovingAverage((XYDataset)highLowData, " (Moving Average)", 432000000L, 432000000L);
        plot.setDataset(1, maData);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        renderer2.setToolTipGenerator(new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0,000.0")));
        plot.setRenderer(1, renderer2);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createHorizontallyCombinedChart() {
        String title = this.resources.getString("combined.horizontal.title");
        String subtitleStr = this.resources.getString("combined.horizontal.subtitle");
        String[] domains = this.resources.getStringArray("combined.horizontal.domains");
        String rangeAxisLabel = this.resources.getString("combined.horizontal.range");
        TimeSeriesCollection dataset0 = new TimeSeriesCollection();
        TimeSeries eur = DemoDatasetFactory.createEURTimeSeries();
        dataset0.addSeries(eur);
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        TimeSeries mav = MovingAverage.createMovingAverage(eur, "EUR/GBP (30 Day MA)", 30, 30);
        dataset1.addSeries(eur);
        dataset1.addSeries(mav);
        TimeSeriesCollection dataset2 = new TimeSeriesCollection();
        dataset2.addSeries(eur);
        NumberAxis valueAxis = new NumberAxis(rangeAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        CombinedRangeXYPlot parent = new CombinedRangeXYPlot(valueAxis);
        parent.setRenderer(new StandardXYItemRenderer());
        int[] weight = new int[]{1, 1, 1};
        XYPlot subplot1 = new XYPlot(dataset0, new DateAxis(domains[0]), null, new StandardXYItemRenderer());
        parent.add(subplot1, weight[0]);
        XYPlot subplot2 = new XYPlot(dataset1, new DateAxis(domains[1]), null, new StandardXYItemRenderer());
        parent.add(subplot2, weight[1]);
        XYPlot subplot3 = new XYPlot(dataset2, new DateAxis(domains[2]), null, new XYBarRenderer(0.2));
        parent.add(subplot3, weight[2]);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, parent, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createVerticallyCombinedChart() {
        String title = this.resources.getString("combined.vertical.title");
        String subtitleStr = this.resources.getString("combined.vertical.subtitle");
        String domain = this.resources.getString("combined.vertical.domain");
        String[] ranges = this.resources.getStringArray("combined.vertical.ranges");
        TimeSeriesCollection dataset0 = new TimeSeriesCollection();
        TimeSeries eur = DemoDatasetFactory.createEURTimeSeries();
        dataset0.addSeries(eur);
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        TimeSeries jpy = DemoDatasetFactory.createJPYTimeSeries();
        TimeSeries mav = MovingAverage.createMovingAverage(jpy, "JPY/GBP (30 Day MA)", 30, 30);
        dataset1.addSeries(jpy);
        dataset1.addSeries(mav);
        HighLowDataset dataset2 = DemoDatasetFactory.createHighLowDataset();
        TimeSeriesCollection dataset3 = new TimeSeriesCollection();
        dataset3.addSeries(eur);
        DateAxis timeAxis = new DateAxis(domain);
        CombinedDomainXYPlot multiPlot = new CombinedDomainXYPlot(timeAxis);
        int[] weight = new int[]{1, 1, 1, 1};
        XYPlot subplot1 = new XYPlot(dataset0, null, new NumberAxis(ranges[0]), new StandardXYItemRenderer());
        NumberAxis range1 = (NumberAxis)subplot1.getRangeAxis();
        range1.setTickLabelFont(new Font("Monospaced", 0, 7));
        range1.setLabelFont(new Font("SansSerif", 0, 8));
        range1.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot1, weight[0]);
        XYPlot subplot2 = new XYPlot(dataset1, null, new NumberAxis(ranges[1]), new StandardXYItemRenderer());
        NumberAxis range2 = (NumberAxis)subplot2.getRangeAxis();
        range2.setTickLabelFont(new Font("Monospaced", 0, 7));
        range2.setLabelFont(new Font("SansSerif", 0, 8));
        range2.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot2, weight[1]);
        XYPlot subplot3 = new XYPlot(dataset2, null, new NumberAxis(ranges[2]), null);
        HighLowRenderer renderer3 = new HighLowRenderer();
        subplot3.setRenderer(renderer3);
        NumberAxis range3 = (NumberAxis)subplot3.getRangeAxis();
        range3.setTickLabelFont(new Font("Monospaced", 0, 7));
        range3.setLabelFont(new Font("SansSerif", 0, 8));
        range3.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot3, weight[2]);
        XYPlot subplot4 = new XYPlot(dataset3, null, new NumberAxis(ranges[3]), null);
        XYBarRenderer renderer4 = new XYBarRenderer();
        subplot4.setRenderer(renderer4);
        NumberAxis range4 = (NumberAxis)subplot4.getRangeAxis();
        range4.setTickLabelFont(new Font("Monospaced", 0, 7));
        range4.setLabelFont(new Font("SansSerif", 0, 8));
        range4.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot4, weight[3]);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, multiPlot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createCombinedAndOverlaidChart1() {
        String title = this.resources.getString("combined.combined-overlaid.title");
        String subtitleStr = this.resources.getString("combined.combined-overlaid.subtitle");
        String domain = this.resources.getString("combined.combined-overlaid.domain");
        String[] ranges = this.resources.getStringArray("combined.combined-overlaid.ranges");
        TimeSeries jpy = DemoDatasetFactory.createJPYTimeSeries();
        TimeSeries mav = MovingAverage.createMovingAverage(jpy, "30 Day Moving Average", 30, 30);
        TimeSeriesCollection dataset0 = new TimeSeriesCollection();
        dataset0.addSeries(jpy);
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        dataset1.addSeries(jpy);
        dataset1.addSeries(mav);
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        XYDataset highLowDatasetMA = MovingAverage.createMovingAverage((XYDataset)highLowDataset, " (MA)", 432000000L, 432000000L);
        NumberAxis[] valueAxis = new NumberAxis[3];
        int i = 0;
        while (i < valueAxis.length) {
            valueAxis[i] = new NumberAxis(ranges[i]);
            if (i <= 1) {
                valueAxis[i].setAutoRangeIncludesZero(false);
            }
            ++i;
        }
        CombinedDomainXYPlot parent = new CombinedDomainXYPlot(new DateAxis(domain));
        int[] weight = new int[]{1, 2, 2};
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        XYPlot subplot1 = new XYPlot(dataset0, null, new NumberAxis(ranges[0]), renderer1);
        NumberAxis axis1 = (NumberAxis)subplot1.getRangeAxis();
        axis1.setTickLabelFont(new Font("Monospaced", 0, 7));
        axis1.setLabelFont(new Font("SansSerif", 0, 8));
        axis1.setAutoRangeIncludesZero(false);
        parent.add(subplot1, weight[0]);
        XYPlot subplot2 = new XYPlot(dataset0, null, new NumberAxis(ranges[1]), new StandardXYItemRenderer());
        NumberAxis axis2 = (NumberAxis)subplot2.getRangeAxis();
        axis2.setTickLabelFont(new Font("Monospaced", 0, 7));
        axis2.setLabelFont(new Font("SansSerif", 0, 8));
        axis2.setAutoRangeIncludesZero(false);
        subplot2.setDataset(1, dataset1);
        subplot2.setRenderer(1, new StandardXYItemRenderer());
        parent.add(subplot2, weight[1]);
        HighLowRenderer renderer3 = new HighLowRenderer();
        XYPlot subplot3 = new XYPlot(highLowDataset, null, new NumberAxis(ranges[2]), renderer3);
        NumberAxis axis3 = (NumberAxis)subplot3.getRangeAxis();
        axis3.setTickLabelFont(new Font("Monospaced", 0, 7));
        axis3.setLabelFont(new Font("SansSerif", 0, 8));
        axis3.setAutoRangeIncludesZero(false);
        subplot3.setDataset(1, highLowDatasetMA);
        subplot3.setRenderer(1, new StandardXYItemRenderer());
        parent.add(subplot3, weight[2]);
        JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 12), parent, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 10));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createCombinedAndOverlaidDynamicXYChart() {
        String title = this.resources.getString("combined.dynamic.title");
        String subtitleStr = this.resources.getString("combined.dynamic.subtitle");
        String domainAxisLabel = this.resources.getString("combined.dynamic.domain");
        String[] ranges = this.resources.getStringArray("combined.dynamic.ranges");
        SampleXYDataset data = new SampleXYDataset();
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        CombinedDataset combinedData = new CombinedDataset();
        combinedData.add(series0);
        combinedData.add(series1);
        NumberAxis timeAxis = new NumberAxis(domainAxisLabel);
        timeAxis.setTickMarksVisible(true);
        timeAxis.setAutoRangeIncludesZero(false);
        NumberAxis[] valueAxis = new NumberAxis[4];
        int i = 0;
        while (i < valueAxis.length) {
            valueAxis[i] = new NumberAxis(ranges[i]);
            valueAxis[i].setAutoRangeIncludesZero(false);
            ++i;
        }
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot(timeAxis);
        StandardXYItemRenderer renderer0 = new StandardXYItemRenderer();
        XYPlot subplot0 = new XYPlot(series0, null, valueAxis[0], renderer0);
        plot.add(subplot0, 1);
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        XYPlot subplot1 = new XYPlot(series1, null, valueAxis[1], renderer1);
        plot.add(subplot1, 1);
        XYPlot subplot2 = new XYPlot(series0, null, valueAxis[2], new StandardXYItemRenderer());
        subplot2.setDataset(1, series1);
        subplot2.setRenderer(1, new StandardXYItemRenderer());
        plot.add(subplot2, 1);
        StandardXYItemRenderer renderer3 = new StandardXYItemRenderer();
        XYPlot subplot3 = new XYPlot(data, null, valueAxis[3], renderer3);
        plot.add(subplot3, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.cyan));
        SampleXYDatasetThread update = new SampleXYDatasetThread(data);
        Thread thread = new Thread(update);
        thread.start();
        return chart;
    }

    public JFreeChart createGanttChart() {
        String title = this.resources.getString("gantt.task.title");
        String domain = this.resources.getString("gantt.task.domain");
        String range = this.resources.getString("gantt.task.range");
        IntervalCategoryDataset data = JFreeChartDemoBase.createGanttDataset1();
        JFreeChart chart = ChartFactory.createGanttChart(title, domain, range, data, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        return chart;
    }

    private static IntervalCategoryDataset createGanttDataset1() {
        TaskSeries s1 = new TaskSeries("Scheduled");
        s1.add(new Task("Write Proposal", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 3, 2001), JFreeChartDemoBase.date(5, 3, 2001))));
        s1.add(new Task("Obtain Approval", new SimpleTimePeriod(JFreeChartDemoBase.date(9, 3, 2001), JFreeChartDemoBase.date(9, 3, 2001))));
        s1.add(new Task("Requirements Analysis", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 3, 2001), JFreeChartDemoBase.date(5, 4, 2001))));
        s1.add(new Task("Design Phase", new SimpleTimePeriod(JFreeChartDemoBase.date(6, 4, 2001), JFreeChartDemoBase.date(30, 4, 2001))));
        s1.add(new Task("Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(2, 5, 2001), JFreeChartDemoBase.date(2, 5, 2001))));
        s1.add(new Task("Alpha Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(3, 5, 2001), JFreeChartDemoBase.date(31, 6, 2001))));
        s1.add(new Task("Design Review", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 7, 2001), JFreeChartDemoBase.date(8, 7, 2001))));
        s1.add(new Task("Revised Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 7, 2001), JFreeChartDemoBase.date(10, 7, 2001))));
        s1.add(new Task("Beta Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(12, 7, 2001), JFreeChartDemoBase.date(12, 8, 2001))));
        s1.add(new Task("Testing", new SimpleTimePeriod(JFreeChartDemoBase.date(13, 8, 2001), JFreeChartDemoBase.date(31, 9, 2001))));
        s1.add(new Task("Final Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 10, 2001), JFreeChartDemoBase.date(15, 10, 2001))));
        s1.add(new Task("Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(28, 10, 2001), JFreeChartDemoBase.date(30, 10, 2001))));
        TaskSeries s2 = new TaskSeries("Actual");
        s2.add(new Task("Write Proposal", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 3, 2001), JFreeChartDemoBase.date(5, 3, 2001))));
        s2.add(new Task("Obtain Approval", new SimpleTimePeriod(JFreeChartDemoBase.date(9, 3, 2001), JFreeChartDemoBase.date(9, 3, 2001))));
        s2.add(new Task("Requirements Analysis", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 3, 2001), JFreeChartDemoBase.date(15, 4, 2001))));
        s2.add(new Task("Design Phase", new SimpleTimePeriod(JFreeChartDemoBase.date(15, 4, 2001), JFreeChartDemoBase.date(17, 5, 2001))));
        s2.add(new Task("Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(30, 5, 2001), JFreeChartDemoBase.date(30, 5, 2001))));
        s2.add(new Task("Alpha Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 6, 2001), JFreeChartDemoBase.date(12, 8, 2001))));
        s2.add(new Task("Design Review", new SimpleTimePeriod(JFreeChartDemoBase.date(12, 8, 2001), JFreeChartDemoBase.date(22, 8, 2001))));
        s2.add(new Task("Revised Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(25, 8, 2001), JFreeChartDemoBase.date(27, 8, 2001))));
        s2.add(new Task("Beta Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(27, 8, 2001), JFreeChartDemoBase.date(30, 9, 2001))));
        s2.add(new Task("Testing", new SimpleTimePeriod(JFreeChartDemoBase.date(31, 9, 2001), JFreeChartDemoBase.date(17, 10, 2001))));
        s2.add(new Task("Final Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(18, 10, 2001), JFreeChartDemoBase.date(5, 11, 2001))));
        s2.add(new Task("Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 11, 2001), JFreeChartDemoBase.date(11, 11, 2001))));
        TaskSeriesCollection collection = new TaskSeriesCollection();
        collection.add(s1);
        collection.add(s2);
        return collection;
    }

    private static Date date(int day, int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }

    public JFreeChart createWaferMapChart() {
        WaferMapDataset dataset = DemoDatasetFactory.createRandomWaferMapDataset(5);
        JFreeChart chart = ChartFactory.createWaferMapChart("Wafer Map Demo", dataset, PlotOrientation.VERTICAL, true, false, false);
        Legend legend = chart.getLegend();
        legend.setAnchor(2);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        TextTitle copyright = new TextTitle("JFreeChart WaferMapPlot", new Font("SansSerif", 0, 9));
        copyright.setPosition(RectangleEdge.BOTTOM);
        copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle(copyright);
        return chart;
    }

    public JFreeChart createWaferMapChartValueIndexed() {
        WaferMapDataset dataset = DemoDatasetFactory.createRandomWaferMapDataset(500);
        JFreeChart chart = ChartFactory.createWaferMapChart("Wafer Map Demo - Value Indexed", dataset, PlotOrientation.VERTICAL, true, false, false);
        Legend legend = chart.getLegend();
        legend.setAnchor(2);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        TextTitle copyright = new TextTitle("JFreeChart WaferMapPlot", new Font("SansSerif", 0, 9));
        copyright.setPosition(RectangleEdge.BOTTOM);
        copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle(copyright);
        return chart;
    }

    public JFreeChart createWaferMapChartPositionIndexed() {
        WaferMapDataset dataset = DemoDatasetFactory.createRandomWaferMapDataset(500);
        WaferMapPlot plot = new WaferMapPlot(dataset);
        WaferMapRenderer renderer = new WaferMapRenderer(35, 0);
        plot.setRenderer(renderer);
        JFreeChart chart = new JFreeChart("Wafer Map Demo - Position Indexed", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        Legend legend = chart.getLegend();
        legend.setAnchor(2);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        TextTitle copyright = new TextTitle("JFreeChart WaferMapPlot", new Font("SansSerif", 0, 9));
        copyright.setPosition(RectangleEdge.BOTTOM);
        copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle(copyright);
        return chart;
    }
}

