/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LayeredBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class LayeredBarChartDemo1
extends ApplicationFrame {
    public LayeredBarChartDemo1(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{41.0, 33.0, 22.0, 64.0, 42.0, 62.0, 22.0, 14.0}, {55.0, 63.0, 55.0, 48.0, 54.0, 37.0, 41.0, 39.0}, {57.0, 75.0, 43.0, 33.0, 63.0, 46.0, 57.0, 33.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Factor ", (double[][])data);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        categoryAxis.setMaxCategoryLabelWidthRatio(10.0f);
        NumberAxis valueAxis = new NumberAxis("Score (%)");
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, new LayeredBarRenderer());
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart chart = new JFreeChart("Layered Bar Chart", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        chart.setBackgroundPaint(Color.lightGray);
        LayeredBarRenderer renderer = (LayeredBarRenderer)plot.getRenderer();
        renderer.setSeriesBarWidth(0, 1.0);
        renderer.setSeriesBarWidth(1, 0.7);
        renderer.setSeriesBarWidth(2, 0.4);
        renderer.setItemMargin(0.01);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryMargin(0.25);
        domainAxis.setUpperMargin(0.05);
        domainAxis.setLowerMargin(0.05);
        return chart;
    }

    public static void main(String[] args) {
        LayeredBarChartDemo1 demo = new LayeredBarChartDemo1("Layered Bar Chart Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

