/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class LegendManiaDemo
extends ApplicationFrame {
    private static final String CHART_TITLE = "Legend Mania Demo";
    private static final Paint BACKGROUND_PAINT = new Color(255, 240, 240);
    private JFreeChart demoChart;

    public LegendManiaDemo(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        this.demoChart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(this.demoChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        String series1 = "Birds";
        String series2 = "Beas";
        String series3 = "A very very very very very long snake";
        String category1 = "Shopping";
        String category2 = "Socializing";
        String category3 = "Sex";
        String category4 = "TV Watching";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"Birds"), (Comparable)((Object)"Shopping"));
        dataset.addValue(4.0, (Comparable)((Object)"Birds"), (Comparable)((Object)"Socializing"));
        dataset.addValue(3.0, (Comparable)((Object)"Birds"), (Comparable)((Object)"Sex"));
        dataset.addValue(5.0, (Comparable)((Object)"Birds"), (Comparable)((Object)"TV Watching"));
        dataset.addValue(5.0, (Comparable)((Object)"Beas"), (Comparable)((Object)"Shopping"));
        dataset.addValue(7.0, (Comparable)((Object)"Beas"), (Comparable)((Object)"Socializing"));
        dataset.addValue(6.0, (Comparable)((Object)"Beas"), (Comparable)((Object)"Sex"));
        dataset.addValue(8.0, (Comparable)((Object)"Beas"), (Comparable)((Object)"TV Watching"));
        dataset.addValue(4.0, (Comparable)((Object)"A very very very very very long snake"), (Comparable)((Object)"Shopping"));
        dataset.addValue(3.0, (Comparable)((Object)"A very very very very very long snake"), (Comparable)((Object)"Socializing"));
        dataset.addValue(2.0, (Comparable)((Object)"A very very very very very long snake"), (Comparable)((Object)"Sex"));
        dataset.addValue(3.0, (Comparable)((Object)"A very very very very very long snake"), (Comparable)((Object)"TV Watching"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart(CHART_TITLE, "Activity", "Rate", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new Color(255, 255, 180));
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(BACKGROUND_PAINT);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(0.5235987755982988));
        StandardLegend legend = (StandardLegend)chart.getLegend();
        legend.setBackgroundPaint(Color.orange);
        legend.setOutlinePaint(Color.orange);
        legend.setPreferredWidth(125.0);
        return chart;
    }

    public static void main(String[] args) {
        LegendManiaDemo demo = new LegendManiaDemo(CHART_TITLE);
        demo.pack();
        demo.setSize(800, 600);
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
        UpdaterThread updater = demo.new UpdaterThread();
        updater.setDaemon(true);
        updater.start();
    }

    private class UpdaterThread
    extends Thread {
        UpdaterThread() {
        }

        public void run() {
            int[] nArray = new int[12];
            nArray[0] = 161;
            nArray[1] = 1;
            nArray[2] = 177;
            nArray[3] = 178;
            nArray[4] = 2;
            nArray[5] = 194;
            nArray[6] = 195;
            nArray[7] = 3;
            nArray[8] = 211;
            nArray[9] = 208;
            nArray[11] = 160;
            int[] anchors = nArray;
            String[] anchorNames = new String[]{"NORTH_NORTHWEST", "NORTH", "NORTH_NORTHEAST", "EAST_NORTHEAST", "EAST", "EAST_SOUTHEAST", "SOUTH_SOUTHEAST", "SOUTH", "SOUTH_SOUTHWEST", "WEST_SOUTHWEST", "WEST", "WEST_NORTHWEST"};
            this.setPriority(1);
            StandardLegend legend = (StandardLegend)LegendManiaDemo.this.demoChart.getLegend();
            int i = 0;
            while (true) {
                legend.setTitle(anchorNames[i]);
                legend.setAnchor(anchors[i]);
                i = (i + 1) % anchors.length;
                legend.setBoundingBoxArcHeight(0);
                legend.setBoundingBoxArcWidth(0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                legend.setBoundingBoxArcHeight(10);
                legend.setBoundingBoxArcWidth(10);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

