/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class LineChartDemo5
extends ApplicationFrame {
    public LineChartDemo5(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String type1 = "Type 1";
        String type2 = "Type 2";
        String type3 = "Type 3";
        String type4 = "Type 4";
        String type5 = "Type 5";
        String type6 = "Type 6";
        String type7 = "Type 7";
        String type8 = "Type 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 1"));
        dataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 2"));
        dataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 3"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 4"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 5"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 6"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 7"));
        dataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 8"));
        dataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 1"));
        dataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 2"));
        dataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 3"));
        dataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 5"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 6"));
        dataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 7"));
        dataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 8"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 4"));
        dataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 5"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 6"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 7"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 8"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart("Line Chart Demo 5", "Type", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        StandardLegend legend = (StandardLegend)chart.getLegend();
        legend.setDisplaySeriesShapes(true);
        Shape[] shapes = new Shape[3];
        int[] xpoints = new int[]{-3, 3, -3};
        int[] nArray = new int[3];
        nArray[0] = -3;
        nArray[2] = 3;
        int[] ypoints = nArray;
        shapes[0] = new Polygon(xpoints, ypoints, 3);
        shapes[1] = new Rectangle2D.Double(-2.0, -3.0, 3.0, 6.0);
        xpoints = new int[]{-3, 3, 3};
        int[] nArray2 = new int[3];
        nArray2[1] = -3;
        nArray2[2] = 3;
        ypoints = nArray2;
        shapes[2] = new Polygon(xpoints, ypoints, 3);
        DefaultDrawingSupplier supplier = new DefaultDrawingSupplier(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, shapes);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setDrawingSupplier(supplier);
        plot.getRenderer().setSeriesStroke(0, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{10.0f, 6.0f}, 0.0f));
        plot.getRenderer().setSeriesStroke(1, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f));
        plot.getRenderer().setSeriesStroke(2, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setDrawShapes(true);
        renderer.setItemLabelsVisible(true);
        renderer.setLabelGenerator(new StandardCategoryLabelGenerator());
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setUpperMargin(0.12);
        return chart;
    }

    public static void main(String[] args) {
        LineChartDemo5 demo = new LineChartDemo5("Line Chart Demo 5");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

