/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.MeterLegend;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.Range;
import org.jfree.ui.RefineryUtilities;

public class MeterChartDemo {
    void displayMeterChart(double value, DialShape shape) {
        DefaultValueDataset data = new DefaultValueDataset(75.0);
        MeterPlot plot = new MeterPlot(data);
        plot.setUnits("Degrees");
        plot.setRange(new Range(20.0, 140.0));
        plot.setNormalRange(new Range(70.0, 100.0));
        plot.setWarningRange(new Range(100.0, 120.0));
        plot.setCriticalRange(new Range(120.0, 140.0));
        plot.setDialShape(shape);
        plot.setNeedlePaint(Color.white);
        plot.setTickLabelFont(new Font("SansSerif", 1, 9));
        plot.setInsets(new Insets(5, 5, 5, 5));
        JFreeChart chart = new JFreeChart("Meter Chart", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        MeterLegend legend = new MeterLegend("Sample Meter");
        chart.setLegend(legend);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame("Meter Chart", chart);
        chartFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly(chartFrame);
        chartFrame.setSize(250, 250);
        chartFrame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java TestMeter <type> <value>");
            System.err.println("Type:  0 = PIE");
            System.err.println("Type:  1 = CIRCLE");
            System.err.println("Type:  2 = CHORD");
        }
        MeterChartDemo h = new MeterChartDemo();
        double val = 85.0;
        DialShape dialShape = DialShape.CIRCLE;
        if (args.length > 0) {
            int type = Integer.parseInt(args[0]);
            if (type == 0) {
                dialShape = DialShape.PIE;
            } else if (type == 1) {
                dialShape = DialShape.CIRCLE;
            } else if (type == 0) {
                dialShape = DialShape.CHORD;
            }
        }
        if (args.length > 1) {
            val = new Double(args[1]);
        }
        h.displayMeterChart(val, dialShape);
    }
}

