/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.SampleXYDataset;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class MouseZoomDemo
extends ApplicationFrame {
    private ChartPanel chartPanel;
    private JCheckBox xzoom;
    private JCheckBox yzoom;

    public MouseZoomDemo(String title) {
        super(title);
        SampleXYDataset data = new SampleXYDataset();
        JFreeChart chart = ChartFactory.createXYLineChart("Mouse Zoom Demo", "X", "Y", data, PlotOrientation.VERTICAL, true, true, false);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setHorizontalZoom(false);
        this.chartPanel.setVerticalZoom(false);
        this.chartPanel.setHorizontalAxisTrace(false);
        this.chartPanel.setVerticalAxisTrace(false);
        this.chartPanel.setFillZoomRectangle(true);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        JPanel main = new JPanel(new BorderLayout());
        JPanel checkpanel = new JPanel();
        this.xzoom = new JCheckBox("Horizontal Mouse Zooming");
        this.xzoom.setSelected(false);
        this.yzoom = new JCheckBox("Vertical Mouse Zooming");
        this.yzoom.setSelected(false);
        CheckListener clisten = new CheckListener();
        this.xzoom.addItemListener(clisten);
        this.yzoom.addItemListener(clisten);
        checkpanel.add(this.xzoom);
        checkpanel.add(this.yzoom);
        main.add((Component)checkpanel, "South");
        main.add(this.chartPanel);
        this.setContentPane(main);
    }

    public static void main(String[] args) {
        Log.getInstance().addTarget(new PrintStreamLogTarget(System.out));
        MouseZoomDemo demo = new MouseZoomDemo("Mouse Zoom Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }

    class CheckListener
    implements ItemListener {
        CheckListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == MouseZoomDemo.this.xzoom) {
                if (e.getStateChange() == 2) {
                    MouseZoomDemo.this.chartPanel.setHorizontalZoom(false);
                    MouseZoomDemo.this.chartPanel.setHorizontalAxisTrace(false);
                    MouseZoomDemo.this.chartPanel.repaint();
                } else {
                    MouseZoomDemo.this.chartPanel.setHorizontalZoom(true);
                    MouseZoomDemo.this.chartPanel.setHorizontalAxisTrace(true);
                }
            } else if (source == MouseZoomDemo.this.yzoom) {
                if (e.getStateChange() == 2) {
                    MouseZoomDemo.this.chartPanel.setVerticalZoom(false);
                    MouseZoomDemo.this.chartPanel.setVerticalAxisTrace(false);
                    MouseZoomDemo.this.chartPanel.repaint();
                } else {
                    MouseZoomDemo.this.chartPanel.setVerticalZoom(true);
                    MouseZoomDemo.this.chartPanel.setVerticalAxisTrace(true);
                }
            }
        }
    }
}

