/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.MovingAverage;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MovingAverageDemo
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public MovingAverageDemo(String title) {
        super(title);
        String chartTitle = "Legal & General Unit Trust Prices";
        XYDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Legal & General Unit Trust Prices", "Date", "Price Per Unit", dataset, true, true, false);
        StandardLegend legend = (StandardLegend)chart.getLegend();
        legend.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setPlotShapes(true);
            rr.setShapesFilled(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("MMM-yyyy"));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public XYDataset createDataset() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Month");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("L&G European Index Trust", clazz);
        s1.add((RegularTimePeriod)new Month(2, 2001), 181.8);
        s1.add((RegularTimePeriod)new Month(3, 2001), 167.3);
        s1.add((RegularTimePeriod)new Month(4, 2001), 153.8);
        s1.add((RegularTimePeriod)new Month(5, 2001), 167.6);
        s1.add((RegularTimePeriod)new Month(6, 2001), 158.8);
        s1.add((RegularTimePeriod)new Month(7, 2001), 148.3);
        s1.add((RegularTimePeriod)new Month(8, 2001), 153.9);
        s1.add((RegularTimePeriod)new Month(9, 2001), 142.7);
        s1.add((RegularTimePeriod)new Month(10, 2001), 123.2);
        s1.add((RegularTimePeriod)new Month(11, 2001), 131.8);
        s1.add((RegularTimePeriod)new Month(12, 2001), 139.6);
        s1.add((RegularTimePeriod)new Month(1, 2002), 142.9);
        s1.add((RegularTimePeriod)new Month(2, 2002), 138.7);
        s1.add((RegularTimePeriod)new Month(3, 2002), 137.3);
        s1.add((RegularTimePeriod)new Month(4, 2002), 143.9);
        s1.add((RegularTimePeriod)new Month(5, 2002), 139.8);
        s1.add((RegularTimePeriod)new Month(6, 2002), 137.0);
        s1.add((RegularTimePeriod)new Month(7, 2002), 132.8);
        TimeSeries s2 = MovingAverage.createMovingAverage(s1, "Six Month Moving Average", 6, 0);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    public static void main(String[] args) {
        MovingAverageDemo demo = new MovingAverageDemo("Moving Average Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

