/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class MultipleAxisDemo2
extends ApplicationFrame {
    public MultipleAxisDemo2(String title) {
        super(title);
        JFreeChart chart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(600, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart() {
        XYDataset dataset1 = this.createDataset("Series 1", 100.0, new Minute(), 200);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Multiple Axis Demo 2", "Time of Day", "Primary Range Axis", dataset1, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPaint(Color.black);
        NumberAxis xAxis2 = new NumberAxis("Domain Axis 2");
        xAxis2.setAutoRangeIncludesZero(false);
        plot.setDomainAxis(1, xAxis2);
        NumberAxis yAxis2 = new NumberAxis("Range Axis 2");
        plot.setRangeAxis(1, yAxis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        XYDataset dataset2 = this.createDataset("Series 2", 1000.0, new Minute(), 170);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToDomainAxis(1, 1);
        plot.mapDatasetToRangeAxis(1, 1);
        return chart;
    }

    private XYDataset createDataset(String name, double base, RegularTimePeriod start, int count) {
        TimeSeries series = new TimeSeries(name, start.getClass());
        RegularTimePeriod period = start;
        double value = base;
        int i = 0;
        while (i < count) {
            series.add(period, value);
            period = period.next();
            value *= 1.0 + (Math.random() - 0.495) / 10.0;
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public static void main(String[] args) {
        MultipleAxisDemo2 demo = new MultipleAxisDemo2("Multiple Axis Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

