/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class MultipleDatasetDemo1
extends ApplicationFrame
implements ActionListener {
    private XYPlot plot;
    private int datasetIndex = 0;

    public MultipleDatasetDemo1(String title) {
        super(title);
        TimeSeriesCollection dataset1 = this.createRandomDataset("Series 1");
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Multiple Dataset Demo 1", "Time", "Value", dataset1, true, true, false);
        chart.setBackgroundPaint(Color.white);
        this.plot = chart.getXYPlot();
        this.plot.setBackgroundPaint(Color.lightGray);
        this.plot.setDomainGridlinePaint(Color.white);
        this.plot.setRangeGridlinePaint(Color.white);
        this.plot.setAxisOffset(new Spacer(1, 4.0, 4.0, 4.0, 4.0));
        ValueAxis axis = this.plot.getDomainAxis();
        axis.setAutoRange(true);
        NumberAxis rangeAxis2 = new NumberAxis("Range Axis 2");
        rangeAxis2.setAutoRangeIncludesZero(false);
        JPanel content = new JPanel(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(chart);
        content.add(chartPanel);
        JButton button1 = new JButton("Add Dataset");
        button1.setActionCommand("ADD_DATASET");
        button1.addActionListener(this);
        JButton button2 = new JButton("Remove Dataset");
        button2.setActionCommand("REMOVE_DATASET");
        button2.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(button1);
        buttonPanel.add(button2);
        content.add((Component)buttonPanel, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(content);
    }

    private TimeSeriesCollection createRandomDataset(String name) {
        TimeSeries series = new TimeSeries(name);
        double value = 100.0;
        RegularTimePeriod t = new Day();
        int i = 0;
        while (i < 50) {
            series.add(t, value);
            t = ((RegularTimePeriod)t).next();
            value *= 1.0 + Math.random() / 100.0;
            ++i;
        }
        return new TimeSeriesCollection(series);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ADD_DATASET")) {
            if (this.datasetIndex < 20) {
                ++this.datasetIndex;
                this.plot.setDataset(this.datasetIndex, this.createRandomDataset("S" + this.datasetIndex));
                this.plot.setRenderer(this.datasetIndex, new StandardXYItemRenderer());
            }
        } else if (e.getActionCommand().equals("REMOVE_DATASET") && this.datasetIndex >= 1) {
            this.plot.setDataset(this.datasetIndex, null);
            this.plot.setRenderer(this.datasetIndex, null);
            --this.datasetIndex;
        }
    }

    public static void main(String[] args) {
        MultipleDatasetDemo1 demo = new MultipleDatasetDemo1("Multiple Dataset Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

