/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.TableOrder;

public class MultiplePieChartDemo1
extends ApplicationFrame {
    public MultiplePieChartDemo1(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart, true, true, true, false, true);
        chartPanel.setPreferredSize(new Dimension(600, 380));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{3.0, 4.0, 3.0, 5.0}, {5.0, 7.0, 6.0, 8.0}, {5.0, 7.0, 3.0, 8.0}, {1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 2.0, 3.0}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("Region ", "Sales/Q", (double[][])data);
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createMultiplePieChart("Multiple Pie Chart", dataset, TableOrder.BY_ROW, true, true, false);
        MultiplePiePlot plot = (MultiplePiePlot)chart.getPlot();
        JFreeChart subchart = plot.getPieChart();
        PiePlot p = (PiePlot)subchart.getPlot();
        p.setLabelGenerator(new StandardPieItemLabelGenerator("{0}"));
        p.setLabelFont(new Font("SansSerif", 0, 8));
        p.setInteriorGap(0.3);
        return chart;
    }

    public static void main(String[] args) {
        MultiplePieChartDemo1 demo = new MultiplePieChartDemo1("Multiple Pie Chart Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

