/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.TableOrder;

public class MultiplePieChartDemo4
extends ApplicationFrame {
    public MultiplePieChartDemo4(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart, true, true, true, false, true);
        chartPanel.setPreferredSize(new Dimension(600, 380));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(5.6, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 0"));
        dataset.addValue(3.2, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 1"));
        dataset.addValue(1.8, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 2"));
        dataset.addValue(0.2, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 3"));
        dataset.addValue(4.1, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 4"));
        dataset.addValue(9.8, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 0"));
        dataset.addValue(6.3, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.addValue(0.1, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        dataset.addValue(1.9, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 3"));
        dataset.addValue(9.6, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 4"));
        dataset.addValue(7.0, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 0"));
        dataset.addValue(5.2, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 1"));
        dataset.addValue(2.8, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 2"));
        dataset.addValue(8.8, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 3"));
        dataset.addValue(7.2, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 4"));
        dataset.addValue(9.5, (Comparable)((Object)"Row 3"), (Comparable)((Object)"Column 0"));
        dataset.addValue(1.2, (Comparable)((Object)"Row 3"), (Comparable)((Object)"Column 1"));
        dataset.addValue(4.5, (Comparable)((Object)"Row 3"), (Comparable)((Object)"Column 2"));
        dataset.addValue(4.4, (Comparable)((Object)"Row 3"), (Comparable)((Object)"Column 3"));
        dataset.addValue(0.2, (Comparable)((Object)"Row 3"), (Comparable)((Object)"Column 4"));
        dataset.addValue(3.5, (Comparable)((Object)"Row 4"), (Comparable)((Object)"Column 0"));
        dataset.addValue(6.7, (Comparable)((Object)"Row 4"), (Comparable)((Object)"Column 1"));
        dataset.addValue(9.0, (Comparable)((Object)"Row 4"), (Comparable)((Object)"Column 2"));
        dataset.addValue(1.0, (Comparable)((Object)"Row 4"), (Comparable)((Object)"Column 3"));
        dataset.addValue(5.2, (Comparable)((Object)"Row 4"), (Comparable)((Object)"Column 4"));
        dataset.addValue(5.1, (Comparable)((Object)"Row 5"), (Comparable)((Object)"Column 0"));
        dataset.addValue(6.7, (Comparable)((Object)"Row 5"), (Comparable)((Object)"Column 1"));
        dataset.addValue(0.9, (Comparable)((Object)"Row 5"), (Comparable)((Object)"Column 2"));
        dataset.addValue(3.3, (Comparable)((Object)"Row 5"), (Comparable)((Object)"Column 3"));
        dataset.addValue(3.9, (Comparable)((Object)"Row 5"), (Comparable)((Object)"Column 4"));
        dataset.addValue(5.6, (Comparable)((Object)"Row 6"), (Comparable)((Object)"Column 0"));
        dataset.addValue(5.6, (Comparable)((Object)"Row 6"), (Comparable)((Object)"Column 1"));
        dataset.addValue(5.6, (Comparable)((Object)"Row 6"), (Comparable)((Object)"Column 2"));
        dataset.addValue(5.6, (Comparable)((Object)"Row 6"), (Comparable)((Object)"Column 3"));
        dataset.addValue(5.6, (Comparable)((Object)"Row 6"), (Comparable)((Object)"Column 4"));
        dataset.addValue(7.5, (Comparable)((Object)"Row 7"), (Comparable)((Object)"Column 0"));
        dataset.addValue(9.0, (Comparable)((Object)"Row 7"), (Comparable)((Object)"Column 1"));
        dataset.addValue(3.4, (Comparable)((Object)"Row 7"), (Comparable)((Object)"Column 2"));
        dataset.addValue(4.1, (Comparable)((Object)"Row 7"), (Comparable)((Object)"Column 3"));
        dataset.addValue(0.5, (Comparable)((Object)"Row 7"), (Comparable)((Object)"Column 4"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createMultiplePieChart3D("Multiple Pie Chart Demo 4", dataset, TableOrder.BY_COLUMN, false, true, false);
        chart.setBackgroundPaint(new Color(216, 255, 216));
        MultiplePiePlot plot = (MultiplePiePlot)chart.getPlot();
        JFreeChart subchart = plot.getPieChart();
        StandardLegend legend = new StandardLegend();
        legend.setItemFont(new Font("SansSerif", 0, 8));
        legend.setAnchor(3);
        subchart.setLegend(legend);
        plot.setLimit(0.1);
        PiePlot p = (PiePlot)subchart.getPlot();
        p.setLabelGenerator(new StandardPieItemLabelGenerator("{0}"));
        p.setLabelFont(new Font("SansSerif", 0, 8));
        p.setInteriorGap(0.3);
        return chart;
    }

    public static void main(String[] args) {
        MultiplePieChartDemo4 demo = new MultiplePieChartDemo4("Multiple Pie Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

