/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.LevelRenderer;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class OverlaidBarChartDemo2
extends ApplicationFrame {
    public OverlaidBarChartDemo2(String title) {
        super(title);
        JFreeChart chart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart() {
        DefaultCategoryDataset dataset1 = new DefaultCategoryDataset();
        dataset1.addValue(1.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Category 1"));
        dataset1.addValue(4.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Category 2"));
        dataset1.addValue(3.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Category 3"));
        dataset1.addValue(5.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Category 4"));
        dataset1.addValue(5.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Category 5"));
        dataset1.addValue(5.0, (Comparable)((Object)"S2"), (Comparable)((Object)"Category 1"));
        dataset1.addValue(7.0, (Comparable)((Object)"S2"), (Comparable)((Object)"Category 2"));
        dataset1.addValue(6.0, (Comparable)((Object)"S2"), (Comparable)((Object)"Category 3"));
        dataset1.addValue(8.0, (Comparable)((Object)"S2"), (Comparable)((Object)"Category 4"));
        dataset1.addValue(4.0, (Comparable)((Object)"S2"), (Comparable)((Object)"Category 5"));
        BarRenderer renderer = new BarRenderer();
        renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot plot = new CategoryPlot();
        plot.setDataset(dataset1);
        plot.setRenderer(renderer);
        plot.setDomainAxis(new CategoryAxis("Category"));
        plot.setRangeAxis(new NumberAxis("Value"));
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinesVisible(true);
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        dataset2.addValue(6.0, (Comparable)((Object)"Prior 1"), (Comparable)((Object)"Category 1"));
        dataset2.addValue(7.0, (Comparable)((Object)"Prior 1"), (Comparable)((Object)"Category 2"));
        dataset2.addValue(2.0, (Comparable)((Object)"Prior 1"), (Comparable)((Object)"Category 3"));
        dataset2.addValue(6.0, (Comparable)((Object)"Prior 1"), (Comparable)((Object)"Category 4"));
        dataset2.addValue(6.0, (Comparable)((Object)"Prior 1"), (Comparable)((Object)"Category 5"));
        dataset2.addValue(4.0, (Comparable)((Object)"Prior 2"), (Comparable)((Object)"Category 1"));
        dataset2.addValue(2.0, (Comparable)((Object)"Prior 2"), (Comparable)((Object)"Category 2"));
        dataset2.addValue(1.0, (Comparable)((Object)"Prior 2"), (Comparable)((Object)"Category 3"));
        dataset2.addValue(3.0, (Comparable)((Object)"Prior 2"), (Comparable)((Object)"Category 4"));
        dataset2.addValue(2.0, (Comparable)((Object)"Prior 2"), (Comparable)((Object)"Category 5"));
        LevelRenderer renderer2 = new LevelRenderer();
        renderer2.setSeriesStroke(0, new BasicStroke(2.0f));
        renderer2.setSeriesStroke(1, new BasicStroke(2.0f));
        plot.setDataset(1, dataset2);
        plot.setRenderer(1, renderer2);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setRangeGridlinePaint(Color.white);
        JFreeChart chart = new JFreeChart(plot);
        chart.setTitle("Overlaid Bar Chart");
        chart.setLegend(new StandardLegend());
        chart.setBackgroundPaint(Color.white);
        return chart;
    }

    public static void main(String[] args) {
        OverlaidBarChartDemo2 demo = new OverlaidBarChartDemo2("Overlaid Bar Chart Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

