/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class OverlaidXYPlotDemo
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public OverlaidXYPlotDemo(String title) {
        super(title);
        JFreeChart chart = this.createOverlaidChart();
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        panel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(panel);
    }

    private JFreeChart createOverlaidChart() {
        IntervalXYDataset data1 = this.createDataset1();
        XYBarRenderer renderer1 = new XYBarRenderer(0.2);
        renderer1.setToolTipGenerator(new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        DateAxis domainAxis = new DateAxis("Date");
        domainAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis rangeAxis = new NumberAxis("Value");
        XYPlot plot = new XYPlot(data1, domainAxis, rangeAxis, renderer1);
        double x = new Day(9, 3, 2002).getMiddleMillisecond();
        XYTextAnnotation annotation = new XYTextAnnotation("Hello!", x, 10000.0);
        annotation.setFont(new Font("SansSerif", 0, 9));
        plot.addAnnotation(annotation);
        XYDataset data2 = this.createDataset2();
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        renderer2.setToolTipGenerator(new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        plot.setDataset(1, data2);
        plot.setRenderer(1, renderer2);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        return new JFreeChart("Overlaid Plot Example", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
    }

    private IntervalXYDataset createDataset1() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series1 = new TimeSeries("Series 1", clazz);
        series1.add((RegularTimePeriod)new Day(1, 3, 2002), 12353.3);
        series1.add((RegularTimePeriod)new Day(2, 3, 2002), 13734.4);
        series1.add((RegularTimePeriod)new Day(3, 3, 2002), 14525.3);
        series1.add((RegularTimePeriod)new Day(4, 3, 2002), 13984.3);
        series1.add((RegularTimePeriod)new Day(5, 3, 2002), 12999.4);
        series1.add((RegularTimePeriod)new Day(6, 3, 2002), 14274.3);
        series1.add((RegularTimePeriod)new Day(7, 3, 2002), 15943.5);
        series1.add((RegularTimePeriod)new Day(8, 3, 2002), 14845.3);
        series1.add((RegularTimePeriod)new Day(9, 3, 2002), 14645.4);
        series1.add((RegularTimePeriod)new Day(10, 3, 2002), 16234.6);
        series1.add((RegularTimePeriod)new Day(11, 3, 2002), 17232.3);
        series1.add((RegularTimePeriod)new Day(12, 3, 2002), 14232.2);
        series1.add((RegularTimePeriod)new Day(13, 3, 2002), 13102.2);
        series1.add((RegularTimePeriod)new Day(14, 3, 2002), 14230.2);
        series1.add((RegularTimePeriod)new Day(15, 3, 2002), 11235.2);
        return new TimeSeriesCollection(series1);
    }

    private XYDataset createDataset2() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series2 = new TimeSeries("Series 2", clazz);
        series2.add((RegularTimePeriod)new Day(3, 3, 2002), 16853.2);
        series2.add((RegularTimePeriod)new Day(4, 3, 2002), 19642.3);
        series2.add((RegularTimePeriod)new Day(5, 3, 2002), 18253.5);
        series2.add((RegularTimePeriod)new Day(6, 3, 2002), 15352.3);
        series2.add((RegularTimePeriod)new Day(7, 3, 2002), 13532.0);
        series2.add((RegularTimePeriod)new Day(8, 3, 2002), 12635.3);
        series2.add((RegularTimePeriod)new Day(9, 3, 2002), 13998.2);
        series2.add((RegularTimePeriod)new Day(10, 3, 2002), 11943.2);
        series2.add((RegularTimePeriod)new Day(11, 3, 2002), 16943.9);
        series2.add((RegularTimePeriod)new Day(12, 3, 2002), 17843.2);
        series2.add((RegularTimePeriod)new Day(13, 3, 2002), 16495.3);
        series2.add((RegularTimePeriod)new Day(14, 3, 2002), 17943.6);
        series2.add((RegularTimePeriod)new Day(15, 3, 2002), 18500.7);
        series2.add((RegularTimePeriod)new Day(16, 3, 2002), 19595.9);
        TimeSeriesCollection tsc = new TimeSeriesCollection(series2);
        return tsc;
    }

    public static void main(String[] args) {
        OverlaidXYPlotDemo demo = new OverlaidXYPlotDemo("Overlaid XYPlot Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

