/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.RefineryUtilities;

public class PanScrollZoomDemo
extends JFrame
implements ActionListener,
ChangeListener,
ChartChangeListener,
MouseListener,
MouseMotionListener {
    private ChartPanel chartPanel;
    private double scrollFactor = 1000.0;
    private JScrollBar scrollBar;
    private Point2D panStartPoint;
    private double[] primYMinMax = new double[2];
    private double[] secondYMinMax = new double[2];
    private static final String ACTION_CMD_PAN = "pan";
    private static final String ACTION_CMD_ZOOM_BOX = "zoomBox";
    private static final String ACTION_CMD_ZOOM_TO_FIT = "zoomFit";
    private static final String ACTION_CMD_ZOOM_IN = "zoomIn";
    private static final String ACTION_CMD_ZOOM_OUT = "zoomOut";
    private static final double ZOOM_FACTOR = 0.8;
    private JToolBar toolBar = this.createToolbar();
    private AbstractButton zoomButton;
    private AbstractButton panButton;
    private AbstractButton zoomInButton;
    private AbstractButton zoomOutButton;
    private AbstractButton fitButton;
    static /* synthetic */ Class class$0;

    public PanScrollZoomDemo(String frameTitle) {
        super(frameTitle);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "South");
        JFreeChart chart = this.createChart();
        this.scrollBar.setModel(new DefaultBoundedRangeModel());
        this.recalcScrollBar(chart.getPlot());
        this.chartPanel = new ChartPanel(chart){

            public void autoRangeBoth() {
                System.out.println("Use 'Fit all' button");
            }
        };
        chart.addChangeListener(this);
        this.actionPerformed(new ActionEvent(this, 0, ACTION_CMD_ZOOM_BOX));
        this.chartPanel.addMouseListener(this);
        this.chartPanel.addMouseMotionListener(this);
        this.chartPanel.setPopupMenu(null);
        this.getContentPane().add(this.chartPanel);
    }

    private JFreeChart createChart() {
        XYSeriesCollection primaryJFreeColl = new XYSeriesCollection();
        XYSeries left1 = new XYSeries("Left 1");
        left1.add(1.0, 2.0);
        left1.add(2.8, 5.9);
        left1.add(3.0, (Number)null);
        left1.add(3.4, 2.0);
        left1.add(5.0, -1.0);
        left1.add(7.0, 1.0);
        primaryJFreeColl.addSeries(left1);
        XYSeriesCollection secondaryJFreeColl = new XYSeriesCollection();
        XYSeries right1 = new XYSeries("Right 1");
        right1.add(3.5, 2.2);
        right1.add(1.2, 1.3);
        right1.add(5.7, 4.1);
        right1.add(7.5, 7.4);
        secondaryJFreeColl.addSeries(right1);
        NumberAxis xAxis = new NumberAxis("X");
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setAutoRangeStickyZero(false);
        NumberAxis primaryYAxis = new NumberAxis("Y1");
        primaryYAxis.setAutoRangeIncludesZero(false);
        primaryYAxis.setAutoRangeStickyZero(false);
        StandardXYItemRenderer y1Renderer = new StandardXYItemRenderer(2);
        y1Renderer.setSeriesPaint(0, Color.blue);
        y1Renderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        XYPlot xyPlot = new XYPlot(primaryJFreeColl, xAxis, primaryYAxis, y1Renderer);
        NumberAxis secondaryYAxis = new NumberAxis("Y2");
        secondaryYAxis.setAutoRangeIncludesZero(false);
        secondaryYAxis.setAutoRangeStickyZero(false);
        xyPlot.setRangeAxis(1, secondaryYAxis);
        xyPlot.setDataset(1, secondaryJFreeColl);
        xyPlot.mapDatasetToRangeAxis(1, 1);
        xyPlot.mapDatasetToDomainAxis(1, 1);
        StandardXYItemRenderer y2Renderer = new StandardXYItemRenderer(3);
        y2Renderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        xyPlot.setRenderer(1, y2Renderer);
        ValueAxis axis = xyPlot.getRangeAxis();
        this.primYMinMax[0] = -5.0;
        this.primYMinMax[1] = 15.0;
        axis.setLowerBound(this.primYMinMax[0]);
        axis.setUpperBound(this.primYMinMax[1]);
        axis = xyPlot.getRangeAxis(1);
        this.secondYMinMax[0] = -1.0;
        this.secondYMinMax[1] = 10.0;
        axis.setLowerBound(this.secondYMinMax[0]);
        axis.setUpperBound(this.secondYMinMax[1]);
        String title = "To pan in zoom mode hold right mouse pressed";
        JFreeChart ret = new JFreeChart("To pan in zoom mode hold right mouse pressed", null, xyPlot, true);
        TextTitle textTitle = new TextTitle("(but you can only pan if the chart was zoomed before)");
        ret.addSubtitle(textTitle);
        return ret;
    }

    private JToolBar createToolbar() {
        JToolBar toolbar = new JToolBar();
        ButtonGroup groupedButtons = new ButtonGroup();
        this.panButton = new JToggleButton();
        this.prepareButton(this.panButton, ACTION_CMD_PAN, " Pan ", "Pan mode");
        groupedButtons.add(this.panButton);
        toolbar.add(this.panButton);
        this.zoomButton = new JToggleButton();
        this.prepareButton(this.zoomButton, ACTION_CMD_ZOOM_BOX, " Zoom ", "Zoom mode");
        groupedButtons.add(this.zoomButton);
        this.zoomButton.setSelected(true);
        toolbar.add(this.zoomButton);
        toolbar.addSeparator();
        this.zoomInButton = new JButton();
        this.prepareButton(this.zoomInButton, ACTION_CMD_ZOOM_IN, " + ", "Zoom in");
        toolbar.add(this.zoomInButton);
        this.zoomOutButton = new JButton();
        this.prepareButton(this.zoomOutButton, ACTION_CMD_ZOOM_OUT, " - ", "Zoom out");
        toolbar.add(this.zoomOutButton);
        this.fitButton = new JButton();
        this.prepareButton(this.fitButton, ACTION_CMD_ZOOM_TO_FIT, " Fit ", "Fit all");
        toolbar.add(this.fitButton);
        toolbar.addSeparator();
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setModel(new DefaultBoundedRangeModel());
        toolbar.add(this.scrollBar);
        this.zoomOutButton.setEnabled(false);
        this.fitButton.setEnabled(false);
        this.scrollBar.setEnabled(false);
        toolbar.setFloatable(false);
        return toolbar;
    }

    private void prepareButton(AbstractButton button, String actionKey, String buttonLabelText, String toolTipText) {
        button.setActionCommand(actionKey);
        button.setText(buttonLabelText);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
    }

    private void setPanMode(boolean val) {
        this.chartPanel.setHorizontalZoom(!val);
        this.chartPanel.setVerticalZoom(!val);
        if (val) {
            this.chartPanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.chartPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            String acmd = evt.getActionCommand();
            if (acmd.equals(ACTION_CMD_ZOOM_BOX)) {
                this.setPanMode(false);
            } else if (acmd.equals(ACTION_CMD_PAN)) {
                this.setPanMode(true);
            } else if (acmd.equals(ACTION_CMD_ZOOM_IN)) {
                ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
                Rectangle2D rect = info.getPlotInfo().getDataArea();
                this.zoomBoth(rect.getCenterX(), rect.getCenterY(), 0.8);
            } else if (acmd.equals(ACTION_CMD_ZOOM_OUT)) {
                ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
                Rectangle2D rect = info.getPlotInfo().getDataArea();
                this.zoomBoth(rect.getCenterX(), rect.getCenterY(), 1.25);
            } else if (acmd.equals(ACTION_CMD_ZOOM_TO_FIT)) {
                this.chartPanel.autoRangeHorizontal();
                Plot plot = this.chartPanel.getChart().getPlot();
                if (plot instanceof ValueAxisPlot) {
                    XYPlot xyPlot;
                    XYPlot vvPlot = (XYPlot)plot;
                    ValueAxis axis = vvPlot.getRangeAxis();
                    if (axis != null) {
                        axis.setLowerBound(this.primYMinMax[0]);
                        axis.setUpperBound(this.primYMinMax[1]);
                    }
                    if (plot instanceof XYPlot && (axis = (xyPlot = (XYPlot)plot).getRangeAxis(1)) != null) {
                        axis.setLowerBound(this.secondYMinMax[0]);
                        axis.setUpperBound(this.secondYMinMax[1]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent event) {
        try {
            Object src = event.getSource();
            BoundedRangeModel scrollBarModel = this.scrollBar.getModel();
            if (src == scrollBarModel) {
                int val = scrollBarModel.getValue();
                int ext = scrollBarModel.getExtent();
                Plot plot = this.chartPanel.getChart().getPlot();
                if (plot instanceof XYPlot) {
                    XYPlot hvp = (XYPlot)plot;
                    ValueAxis axis = hvp.getDomainAxis();
                    this.chartPanel.getChart().removeChangeListener(this);
                    axis.setRange((double)val / this.scrollFactor, (double)(val + ext) / this.scrollFactor);
                    this.chartPanel.getChart().addChangeListener(this);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void chartChanged(ChartChangeEvent event) {
        try {
            XYPlot vvp;
            ValueAxis yAxis;
            if (event.getChart() == null) {
                return;
            }
            BoundedRangeModel scrollBarModel = this.scrollBar.getModel();
            if (scrollBarModel == null) {
                return;
            }
            boolean chartIsZoomed = false;
            Plot plot = event.getChart().getPlot();
            if (plot instanceof XYPlot) {
                XYPlot hvp = (XYPlot)plot;
                ValueAxis xAxis = hvp.getDomainAxis();
                Range xAxisRange = xAxis.getRange();
                scrollBarModel.removeChangeListener(this);
                int low = (int)(xAxisRange.getLowerBound() * this.scrollFactor);
                scrollBarModel.setValue(low);
                int ext = (int)(xAxisRange.getUpperBound() * this.scrollFactor - (double)low);
                scrollBarModel.setExtent(ext);
                scrollBarModel.addChangeListener(this);
                Range hdr = hvp.getDataRange(xAxis);
                double len = hdr == null ? 0.0 : hdr.getLength();
                chartIsZoomed |= xAxisRange.getLength() < len;
            }
            if (!chartIsZoomed && plot instanceof XYPlot && (yAxis = (vvp = (XYPlot)plot).getRangeAxis()) != null) {
                XYPlot xyPlot;
                boolean bl = chartIsZoomed = yAxis.getLowerBound() > this.primYMinMax[0] || yAxis.getUpperBound() < this.primYMinMax[1];
                if (!chartIsZoomed && plot instanceof XYPlot && (yAxis = (xyPlot = (XYPlot)plot).getRangeAxis(1)) != null) {
                    chartIsZoomed = yAxis.getLowerBound() > this.secondYMinMax[0] || yAxis.getUpperBound() < this.secondYMinMax[1];
                }
            }
            this.panButton.setEnabled(chartIsZoomed);
            this.zoomOutButton.setEnabled(chartIsZoomed);
            this.fitButton.setEnabled(chartIsZoomed);
            this.scrollBar.setEnabled(chartIsZoomed);
            if (!chartIsZoomed) {
                this.setPanMode(false);
                this.zoomButton.setSelected(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent event) {
        try {
            Point point;
            Rectangle2D dataArea;
            if ((this.panButton.isSelected() || this.panButton.isEnabled() && SwingUtilities.isRightMouseButton(event)) && (dataArea = this.chartPanel.getScaledDataArea()).contains(point = event.getPoint())) {
                this.setPanMode(true);
                this.panStartPoint = point;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseReleased(MouseEvent event) {
        try {
            this.panStartPoint = null;
            if (!this.panButton.isSelected()) {
                this.setPanMode(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseDragged(MouseEvent event) {
        try {
            if (this.panStartPoint != null) {
                XYPlot xyPlot;
                double dY;
                XYPlot vvp;
                ValueAxis yAxis;
                double newMax;
                double oldMax;
                double newMin;
                double oldMin;
                double translatedEndPoint;
                double translatedStartPoint;
                XYPlot hvp;
                ValueAxis xAxis;
                Rectangle2D scaledDataArea = this.chartPanel.getScaledDataArea();
                this.panStartPoint = RefineryUtilities.getPointInRectangle(this.panStartPoint.getX(), this.panStartPoint.getY(), scaledDataArea);
                Point2D panEndPoint = RefineryUtilities.getPointInRectangle(event.getX(), event.getY(), scaledDataArea);
                Plot plot = this.chartPanel.getChart().getPlot();
                if (plot instanceof XYPlot && (xAxis = (hvp = (XYPlot)plot).getDomainAxis()) != null) {
                    translatedStartPoint = xAxis.java2DToValue((float)this.panStartPoint.getX(), scaledDataArea, hvp.getDomainAxisEdge());
                    translatedEndPoint = xAxis.java2DToValue((float)panEndPoint.getX(), scaledDataArea, hvp.getDomainAxisEdge());
                    double dX = translatedStartPoint - translatedEndPoint;
                    oldMin = xAxis.getLowerBound();
                    newMin = oldMin + dX;
                    oldMax = xAxis.getUpperBound();
                    newMax = oldMax + dX;
                    if (newMin >= hvp.getDataRange(xAxis).getLowerBound() && newMax <= hvp.getDataRange(xAxis).getUpperBound()) {
                        xAxis.setLowerBound(newMin);
                        xAxis.setUpperBound(newMax);
                    }
                }
                if (plot instanceof XYPlot && (yAxis = (vvp = (XYPlot)plot).getRangeAxis()) != null) {
                    translatedStartPoint = yAxis.java2DToValue((float)this.panStartPoint.getY(), scaledDataArea, vvp.getRangeAxisEdge());
                    translatedEndPoint = yAxis.java2DToValue((float)panEndPoint.getY(), scaledDataArea, vvp.getRangeAxisEdge());
                    dY = translatedStartPoint - translatedEndPoint;
                    oldMin = yAxis.getLowerBound();
                    newMin = oldMin + dY;
                    oldMax = yAxis.getUpperBound();
                    newMax = oldMax + dY;
                    if (newMin >= this.primYMinMax[0] && newMax <= this.primYMinMax[1]) {
                        yAxis.setLowerBound(newMin);
                        yAxis.setUpperBound(newMax);
                    }
                }
                if (plot instanceof XYPlot && (yAxis = (xyPlot = (XYPlot)plot).getRangeAxis(1)) != null) {
                    translatedStartPoint = yAxis.java2DToValue((float)this.panStartPoint.getY(), scaledDataArea, xyPlot.getRangeAxisEdge(1));
                    translatedEndPoint = yAxis.java2DToValue((float)panEndPoint.getY(), scaledDataArea, xyPlot.getRangeAxisEdge(1));
                    dY = translatedStartPoint - translatedEndPoint;
                    oldMin = yAxis.getLowerBound();
                    newMin = oldMin + dY;
                    oldMax = yAxis.getUpperBound();
                    newMax = oldMax + dY;
                    if (newMin >= this.secondYMinMax[0] && newMax <= this.secondYMinMax[1]) {
                        yAxis.setLowerBound(newMin);
                        yAxis.setUpperBound(newMax);
                    }
                }
                this.panStartPoint = panEndPoint;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public static void main(String[] args) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String lookAndFeelClassName = clazz.getName();
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        PanScrollZoomDemo demo = new PanScrollZoomDemo("Pan & Scroll & Zoom - Demo");
        demo.pack();
        demo.setVisible(true);
    }

    private void recalcScrollBar(Plot plot) {
        if (plot instanceof XYPlot) {
            XYPlot hvp = (XYPlot)plot;
            ValueAxis axis = hvp.getDomainAxis();
            axis.setLowerMargin(0.0);
            axis.setUpperMargin(0.0);
            Range rng = axis.getRange();
            BoundedRangeModel scrollBarModel = this.scrollBar.getModel();
            int len = scrollBarModel.getMaximum() - scrollBarModel.getMinimum();
            if (rng.getLength() > 0.0) {
                this.scrollFactor = (double)len / rng.getLength();
            }
            double dblow = rng.getLowerBound();
            int ilow = (int)(dblow * this.scrollFactor);
            scrollBarModel.setMinimum(ilow);
            int val = ilow;
            scrollBarModel.setValue(val);
            double dbup = rng.getUpperBound();
            int iup = (int)(dbup * this.scrollFactor);
            scrollBarModel.setMaximum(iup);
            int ext = iup - ilow;
            scrollBarModel.setExtent(ext);
            scrollBarModel.addChangeListener(this);
        }
    }

    private void zoomBoth(double x, double y, double zoomFactor) {
        this.zoomHorizontal(x, zoomFactor);
        this.zoomVertical(y, zoomFactor);
    }

    private void zoomHorizontal(double x, double zoomFactor) {
        XYPlot hvp;
        ValueAxis axis;
        JFreeChart chart = this.chartPanel.getChart();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (chart.getPlot() instanceof XYPlot && (axis = (hvp = (XYPlot)chart.getPlot()).getDomainAxis()) != null) {
            double anchorValue = axis.java2DToValue((float)x, info.getPlotInfo().getDataArea(), hvp.getDomainAxisEdge());
            if (zoomFactor < 1.0) {
                axis.resizeRange(zoomFactor, anchorValue);
            } else if (zoomFactor > 1.0) {
                Range range = hvp.getDataRange(axis);
                this.adjustRange(axis, range, zoomFactor, anchorValue);
            }
        }
    }

    private void zoomVertical(double y, double zoomFactor) {
        JFreeChart chart = this.chartPanel.getChart();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (chart.getPlot() instanceof XYPlot) {
            XYPlot xyp;
            ValueAxis secYAxis;
            XYPlot vvp = (XYPlot)chart.getPlot();
            ValueAxis primYAxis = vvp.getRangeAxis();
            if (primYAxis != null) {
                double anchorValue = primYAxis.java2DToValue((float)y, info.getPlotInfo().getDataArea(), vvp.getRangeAxisEdge());
                if (zoomFactor < 1.0) {
                    primYAxis.resizeRange(zoomFactor, anchorValue);
                } else if (zoomFactor > 1.0) {
                    Range range = new Range(this.primYMinMax[0], this.primYMinMax[1]);
                    this.adjustRange(primYAxis, range, zoomFactor, anchorValue);
                }
            }
            if (chart.getPlot() instanceof XYPlot && (secYAxis = (xyp = (XYPlot)chart.getPlot()).getRangeAxis(1)) != null) {
                double anchorValue = secYAxis.java2DToValue((float)y, info.getPlotInfo().getDataArea(), xyp.getRangeAxisEdge(1));
                if (zoomFactor < 1.0) {
                    secYAxis.resizeRange(zoomFactor, anchorValue);
                } else if (zoomFactor > 1.0) {
                    Range range = new Range(this.secondYMinMax[0], this.secondYMinMax[1]);
                    this.adjustRange(secYAxis, range, zoomFactor, anchorValue);
                }
            }
        }
    }

    private void adjustRange(ValueAxis axis, Range range, double zoomFactor, double anchorValue) {
        if (axis == null || range == null) {
            return;
        }
        double rangeMinVal = range.getLowerBound() - range.getLength() * axis.getLowerMargin();
        double rangeMaxVal = range.getUpperBound() + range.getLength() * axis.getUpperMargin();
        double halfLength = axis.getRange().getLength() * zoomFactor / 2.0;
        double zoomedMinVal = anchorValue - halfLength;
        double zoomedMaxVal = anchorValue + halfLength;
        double adjMinVal = zoomedMinVal;
        if (zoomedMinVal < rangeMinVal) {
            adjMinVal = rangeMinVal;
            zoomedMaxVal += rangeMinVal - zoomedMinVal;
        }
        double adjMaxVal = zoomedMaxVal;
        if (zoomedMaxVal > rangeMaxVal) {
            adjMaxVal = rangeMaxVal;
            adjMinVal = Math.max(zoomedMinVal -= zoomedMaxVal - rangeMaxVal, rangeMinVal);
        }
        Range adjusted = new Range(adjMinVal, adjMaxVal);
        axis.setRange(adjusted);
    }
}

