/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DataUtilities;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.SortOrder;

public class ParetoChartDemo
extends ApplicationFrame {
    public ParetoChartDemo(String title) {
        super(title);
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Integer(4843));
        data.addValue((Comparable)((Object)"C++"), new Integer(2098));
        data.addValue((Comparable)((Object)"C#"), new Integer(26));
        data.addValue((Comparable)((Object)"Java"), new Integer(1901));
        data.addValue((Comparable)((Object)"Perl"), new Integer(2507));
        data.addValue((Comparable)((Object)"PHP"), new Integer(1689));
        data.addValue((Comparable)((Object)"Python"), new Integer(948));
        data.addValue((Comparable)((Object)"Ruby"), new Integer(100));
        data.addValue((Comparable)((Object)"SQL"), new Integer(263));
        data.addValue((Comparable)((Object)"Unix Shell"), new Integer(485));
        data.sortByValues(SortOrder.DESCENDING);
        KeyedValues cumulative = DataUtilities.getCumulativePercentages(data);
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("Languages", data);
        JFreeChart chart = ChartFactory.createBarChart("Freshmeat Software Projects", "Language", "Projects", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.addSubtitle(new TextTitle("By Programming Language"));
        chart.addSubtitle(new TextTitle("As at 5 March 2003"));
        chart.setBackgroundPaint(new Color(0xBBBBDD));
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLowerMargin(0.02);
        domainAxis.setUpperMargin(0.02);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        CategoryDataset dataset2 = DatasetUtilities.createCategoryDataset("Cumulative", cumulative);
        NumberAxis axis2 = new NumberAxis("Percent");
        axis2.setNumberFormatOverride(NumberFormat.getPercentInstance());
        plot.setRangeAxis(1, axis2);
        plot.setDataset(1, dataset2);
        plot.setRenderer(1, renderer2);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(550, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        ParetoChartDemo demo = new ParetoChartDemo("Pareto Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

