/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.util.Date;

public class Performance2 {
    private double primitive = 42.0;
    private Number object = new Double(42.0);

    public double getPrimitive() {
        return this.primitive;
    }

    public Number getPrimitiveAsObject() {
        return new Double(this.primitive);
    }

    public Number getObject() {
        return this.object;
    }

    public double getObjectAsPrimitive() {
        return this.object.doubleValue();
    }

    public void getPrimitiveLoop(int count) {
        double d = 0.0;
        int i = 0;
        while (i < count) {
            d = this.getPrimitive();
            ++i;
        }
        System.out.println(d);
    }

    public void getPrimitiveAsObjectLoop(int count) {
        double d = 0.0;
        int i = 0;
        while (i < count) {
            d = this.getPrimitiveAsObject().doubleValue();
            ++i;
        }
        System.out.println(d);
    }

    public void getObjectAsPrimitiveLoop(int count) {
        double d = 0.0;
        int i = 0;
        while (i < count) {
            d = this.getObjectAsPrimitive();
            ++i;
        }
        System.out.println(d);
    }

    public void getObjectLoop(int count) {
        double d = 0.0;
        int i = 0;
        while (i < count) {
            d = this.getObject().doubleValue();
            ++i;
        }
        System.out.println(d);
    }

    public void status(String label, Date start, Date end) {
        long elapsed = end.getTime() - start.getTime();
        System.out.println(String.valueOf(label) + start.getTime() + "-->" + end.getTime() + " = " + elapsed);
    }

    public static void main(String[] args) {
        Performance2 performance = new Performance2();
        int count = 10000000;
        int repeat = 0;
        while (repeat < 3) {
            Date s1 = new Date();
            performance.getPrimitiveLoop(10000000);
            Date e1 = new Date();
            performance.status("getPrimitive() : ", s1, e1);
            Date s2 = new Date();
            performance.getPrimitiveAsObjectLoop(10000000);
            Date e2 = new Date();
            performance.status("getPrimitiveAsObject() : ", s2, e2);
            Date s3 = new Date();
            performance.getObjectLoop(10000000);
            Date e3 = new Date();
            performance.status("getObject() : ", s3, e3);
            Date s4 = new Date();
            performance.getObjectAsPrimitiveLoop(10000000);
            Date e4 = new Date();
            performance.status("getObjectAsPrimitive() : ", s4, e4);
            System.out.println("-------------------");
            ++repeat;
        }
    }
}

