/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.TimeZone;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class PeriodAxisDemo2
extends ApplicationFrame {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PeriodAxisDemo2(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Legal & General Unit Trust Prices", "Date", "Price Per Unit", dataset, true, true, false);
        chart.setBackgroundPaint(Color.white);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setPlotShapes(true);
            rr.setShapesFilled(true);
            rr.setItemLabelsVisible(true);
        }
        PeriodAxis domainAxis = new PeriodAxis("Date");
        domainAxis.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        domainAxis.setAutoRangeTimePeriodClass(clazz);
        PeriodAxisLabelInfo[] info = new PeriodAxisLabelInfo[3];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        info[0] = new PeriodAxisLabelInfo(clazz2, "d");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.jfree.data.time.Month");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        info[1] = new PeriodAxisLabelInfo(clazz3, "MMM", new Spacer(1, 2.0, 2.0, 2.0, 2.0), new Font("SansSerif", 1, 10), Color.red, false, null, null);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        info[2] = new PeriodAxisLabelInfo(clazz4, "yyyy");
        domainAxis.setLabelInfo(info);
        plot.setDomainAxis(domainAxis);
        return chart;
    }

    private XYDataset createDataset() {
        TimeSeries s1 = new TimeSeries("L&G European Index Trust");
        s1.add((RegularTimePeriod)new Day(24, 1, 2004), 181.8);
        s1.add((RegularTimePeriod)new Day(25, 1, 2004), 167.3);
        s1.add((RegularTimePeriod)new Day(26, 1, 2004), 153.8);
        s1.add((RegularTimePeriod)new Day(27, 1, 2004), 167.6);
        s1.add((RegularTimePeriod)new Day(28, 1, 2004), 158.8);
        s1.add((RegularTimePeriod)new Day(29, 1, 2004), 148.3);
        s1.add((RegularTimePeriod)new Day(30, 1, 2004), 153.9);
        s1.add((RegularTimePeriod)new Day(31, 1, 2004), 142.7);
        s1.add((RegularTimePeriod)new Day(1, 2, 2004), 123.2);
        s1.add((RegularTimePeriod)new Day(2, 2, 2004), 131.8);
        s1.add((RegularTimePeriod)new Day(3, 2, 2004), 139.6);
        s1.add((RegularTimePeriod)new Day(4, 2, 2004), 142.9);
        s1.add((RegularTimePeriod)new Day(5, 2, 2004), 138.7);
        s1.add((RegularTimePeriod)new Day(6, 2, 2004), 137.3);
        s1.add((RegularTimePeriod)new Day(7, 2, 2004), 143.9);
        s1.add((RegularTimePeriod)new Day(8, 2, 2004), 139.8);
        s1.add((RegularTimePeriod)new Day(9, 2, 2004), 137.0);
        s1.add((RegularTimePeriod)new Day(10, 2, 2004), 132.8);
        TimeZone zone = TimeZone.getTimeZone("Pacific/Auckland");
        TimeSeriesCollection dataset = new TimeSeriesCollection(zone);
        dataset.addSeries(s1);
        dataset.setDomainIsPointsInTime(true);
        dataset.setXPosition(TimePeriodAnchor.MIDDLE);
        return dataset;
    }

    public static void main(String[] args) {
        PeriodAxisDemo2 demo = new PeriodAxisDemo2("Period Axis Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

