/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Rotation;

public class PieChart3DDemo3
extends ApplicationFrame {
    public PieChart3DDemo3(String title) {
        super(title);
        PieDataset dataset = this.createSampleDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private PieDataset createSampleDataset() {
        DefaultPieDataset result = new DefaultPieDataset();
        result.setValue((Comparable)((Object)"Java"), new Double(43.2));
        result.setValue((Comparable)((Object)"Visual Basic"), new Double(10.0));
        result.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        result.setValue((Comparable)((Object)"PHP"), new Double(32.5));
        result.setValue((Comparable)((Object)"Perl"), new Double(1.0));
        return result;
    }

    private JFreeChart createChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart3D("Pie Chart 3D Demo 3", dataset, true, true, false);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        plot.setLabelGenerator(null);
        return chart;
    }

    public static void main(String[] args) {
        PieChart3DDemo3 demo = new PieChart3DDemo3("Pie Chart 3D Demo 3");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

