/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class PieChartDemo4
extends ApplicationFrame {
    public PieChartDemo4(String title) {
        super(title);
        PieDataset dataset = this.createDataset(14);
        JFreeChart chart = ChartFactory.createPieChart("Pie Chart Demo 4", dataset, false, true, false);
        chart.setBackgroundPaint(new Color(222, 222, 255));
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setBackgroundPaint(Color.white);
        plot.setCircular(true);
        plot.setLabelGenerator(new StandardPieItemLabelGenerator("{0} = {2}", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        plot.setNoDataMessage("No data available");
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
        Rotator rotator = new Rotator(plot);
        rotator.start();
    }

    private PieDataset createDataset(int sections) {
        DefaultPieDataset result = new DefaultPieDataset();
        int i = 0;
        while (i < sections) {
            double value = 100.0 * Math.random();
            result.setValue((Comparable)((Object)("Section " + i)), value);
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        PieChartDemo4 demo = new PieChartDemo4("Pie Chart Demo 4");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }

    static class Rotator
    extends Timer
    implements ActionListener {
        private PiePlot plot;
        private int angle = 270;

        Rotator(PiePlot plot) {
            super(100, null);
            this.plot = plot;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent event) {
            this.plot.setStartAngle(this.angle);
            ++this.angle;
            if (this.angle == 360) {
                this.angle = 0;
            }
        }
    }
}

