/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PieChartDemo6
extends ApplicationFrame {
    public PieChartDemo6(String title) {
        super(title);
        PieDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private PieDataset createDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"One"), new Double(43.2));
        dataset.setValue((Comparable)((Object)"Two"), new Double(10.0));
        dataset.setValue((Comparable)((Object)"Three"), new Double(27.5));
        dataset.setValue((Comparable)((Object)"Four"), new Double(17.5));
        dataset.setValue((Comparable)((Object)"Five"), new Double(11.0));
        dataset.setValue((Comparable)((Object)"Six"), new Double(19.4));
        return dataset;
    }

    private JFreeChart createChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart("Pie Chart Demo 6", dataset, false, true, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator(new CustomLabelGenerator());
        return chart;
    }

    public static void main(String[] args) {
        PieChartDemo6 demo = new PieChartDemo6("Pie Chart Demo 6");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }

    static class CustomLabelGenerator
    implements PieSectionLabelGenerator {
        CustomLabelGenerator() {
        }

        public String generateSectionLabel(PieDataset dataset, Comparable key) {
            String result = null;
            if (dataset != null && !key.equals("Two")) {
                result = key.toString();
            }
            return result;
        }
    }
}

