/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class PlotOrientationDemo2
extends ApplicationFrame {
    private static final int CHART_COUNT = 8;
    private XYDataset[] datasets = new XYDataset[8];
    private JFreeChart[] charts = new JFreeChart[8];
    private ChartPanel[] panels = new ChartPanel[8];

    public PlotOrientationDemo2(String title) {
        super(title);
        JPanel panel = new JPanel(new GridLayout(2, 4));
        int i = 0;
        while (i < 8) {
            this.datasets[i] = this.createDataset(i);
            this.charts[i] = this.createChart(i, this.datasets[i]);
            XYPlot plot = this.charts[i].getXYPlot();
            XYShapeAnnotation a1 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 2.0, 3.0), new BasicStroke(1.0f), Color.blue);
            XYLineAnnotation a2 = new XYLineAnnotation(0.0, -5.0, 10.0, -5.0);
            plot.addAnnotation(a1);
            plot.addAnnotation(a2);
            plot.addDomainMarker(new IntervalMarker(5.0, 10.0), Layer.BACKGROUND);
            plot.addRangeMarker(new IntervalMarker(-2.0, 0.0), Layer.BACKGROUND);
            this.panels[i] = new ChartPanel(this.charts[i]);
            ++i;
        }
        this.charts[1].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[2].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[3].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[3].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[5].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[6].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[4].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[4].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[4].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        this.charts[5].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        this.charts[6].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        this.charts[7].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        panel.add(this.panels[0]);
        panel.add(this.panels[1]);
        panel.add(this.panels[4]);
        panel.add(this.panels[5]);
        panel.add(this.panels[2]);
        panel.add(this.panels[3]);
        panel.add(this.panels[6]);
        panel.add(this.panels[7]);
        panel.setPreferredSize(new Dimension(800, 600));
        this.setContentPane(panel);
    }

    private XYDataset createDataset(int index) {
        XYSeries series1 = new XYSeries("Series " + (index + 1));
        series1.add(-10.0, -5.0);
        series1.add(10.0, 5.0);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        return dataset;
    }

    private JFreeChart createChart(int index, XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart("Chart " + (index + 1), "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPlotShapes(true);
        renderer.setShapesFilled(true);
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    public static void main(String[] args) {
        PlotOrientationDemo2 demo = new PlotOrientationDemo2("Plot Orientation Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

