/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.PolarChartPanel;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PolarChartDemo
extends ApplicationFrame {
    public PolarChartDemo(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        PolarChartPanel chartPanel = new PolarChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        XYSeriesCollection data = new XYSeriesCollection();
        XYSeries series1 = PolarChartDemo.createRandomData("Series 1", 75.0, 10.0);
        XYSeries series2 = PolarChartDemo.createRandomData("Series 2", 50.0, 5.0);
        XYSeries series3 = PolarChartDemo.createRandomData("Series 3", 25.0, 1.0);
        data.addSeries(series1);
        data.addSeries(series2);
        data.addSeries(series3);
        return data;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createPolarChart("Polar Chart Demo", dataset, true, true, false);
        PolarPlot plot = (PolarPlot)chart.getPlot();
        DefaultPolarItemRenderer renderer = (DefaultPolarItemRenderer)plot.getRenderer();
        renderer.setSeriesFilled(2, true);
        return chart;
    }

    private static XYSeries createRandomData(String name, double baseRadius, double thetaInc) {
        XYSeries series = new XYSeries(name);
        double theta = 0.0;
        while (theta < 360.0) {
            double radius = baseRadius * (1.0 + Math.random());
            series.add(theta, radius);
            theta += thetaInc;
        }
        return series;
    }

    public static void main(String[] argv) {
        PolarChartDemo demo = new PolarChartDemo("Polar Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

