/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PriceVolumeDemo
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public PriceVolumeDemo(String title) {
        super(title);
        JFreeChart chart = this.createChart();
        ChartPanel panel = new ChartPanel(chart, true, true, true, false, true);
        panel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(panel);
    }

    private JFreeChart createChart() {
        XYDataset priceData = this.createPriceDataset();
        String title = "Eurodollar Futures Contract (MAR03)";
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Eurodollar Futures Contract (MAR03)", "Date", "Price", priceData, true, true, false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis rangeAxis1 = (NumberAxis)plot.getRangeAxis();
        rangeAxis1.setLowerMargin(0.4);
        DecimalFormat format = new DecimalFormat("00.00");
        rangeAxis1.setNumberFormatOverride(format);
        XYItemRenderer renderer1 = plot.getRenderer();
        renderer1.setToolTipGenerator(new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        NumberAxis rangeAxis2 = new NumberAxis("Volume");
        rangeAxis2.setUpperMargin(1.0);
        plot.setRangeAxis(1, rangeAxis2);
        plot.setDataset(1, this.createVolumeDataset());
        plot.setRangeAxis(1, rangeAxis2);
        plot.mapDatasetToRangeAxis(1, 1);
        XYBarRenderer renderer2 = new XYBarRenderer(0.2);
        renderer2.setToolTipGenerator(new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0,000.00")));
        plot.setRenderer(1, renderer2);
        return chart;
    }

    private XYDataset createPriceDataset() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series1 = new TimeSeries("Price", clazz);
        series1.add((RegularTimePeriod)new Day(2, 1, 2002), 95.565);
        series1.add((RegularTimePeriod)new Day(3, 1, 2002), 95.64);
        series1.add((RegularTimePeriod)new Day(4, 1, 2002), 95.71);
        series1.add((RegularTimePeriod)new Day(7, 1, 2002), 95.93);
        series1.add((RegularTimePeriod)new Day(8, 1, 2002), 95.93);
        series1.add((RegularTimePeriod)new Day(9, 1, 2002), 95.96);
        series1.add((RegularTimePeriod)new Day(10, 1, 2002), 96.055);
        series1.add((RegularTimePeriod)new Day(11, 1, 2002), 96.335);
        series1.add((RegularTimePeriod)new Day(14, 1, 2002), 96.29);
        series1.add((RegularTimePeriod)new Day(15, 1, 2002), 96.275);
        series1.add((RegularTimePeriod)new Day(16, 1, 2002), 96.24);
        series1.add((RegularTimePeriod)new Day(17, 1, 2002), 96.08);
        series1.add((RegularTimePeriod)new Day(18, 1, 2002), 96.145);
        series1.add((RegularTimePeriod)new Day(22, 1, 2002), 96.12);
        series1.add((RegularTimePeriod)new Day(23, 1, 2002), 96.015);
        series1.add((RegularTimePeriod)new Day(24, 1, 2002), 95.89);
        series1.add((RegularTimePeriod)new Day(25, 1, 2002), 95.865);
        series1.add((RegularTimePeriod)new Day(28, 1, 2002), 95.88);
        series1.add((RegularTimePeriod)new Day(29, 1, 2002), 96.05);
        series1.add((RegularTimePeriod)new Day(30, 1, 2002), 96.065);
        series1.add((RegularTimePeriod)new Day(31, 1, 2002), 95.91);
        series1.add((RegularTimePeriod)new Day(1, 2, 2002), 96.015);
        series1.add((RegularTimePeriod)new Day(4, 2, 2002), 96.14);
        series1.add((RegularTimePeriod)new Day(5, 2, 2002), 96.195);
        series1.add((RegularTimePeriod)new Day(6, 2, 2002), 96.245);
        series1.add((RegularTimePeriod)new Day(7, 2, 2002), 96.22);
        series1.add((RegularTimePeriod)new Day(8, 2, 2002), 96.28);
        series1.add((RegularTimePeriod)new Day(11, 2, 2002), 96.265);
        series1.add((RegularTimePeriod)new Day(12, 2, 2002), 96.16);
        series1.add((RegularTimePeriod)new Day(13, 2, 2002), 96.12);
        series1.add((RegularTimePeriod)new Day(14, 2, 2002), 96.125);
        series1.add((RegularTimePeriod)new Day(15, 2, 2002), 96.265);
        series1.add((RegularTimePeriod)new Day(19, 2, 2002), 96.29);
        series1.add((RegularTimePeriod)new Day(20, 2, 2002), 96.275);
        series1.add((RegularTimePeriod)new Day(21, 2, 2002), 96.28);
        series1.add((RegularTimePeriod)new Day(22, 2, 2002), 96.305);
        series1.add((RegularTimePeriod)new Day(25, 2, 2002), 96.265);
        series1.add((RegularTimePeriod)new Day(26, 2, 2002), 96.185);
        series1.add((RegularTimePeriod)new Day(27, 2, 2002), 96.305);
        series1.add((RegularTimePeriod)new Day(28, 2, 2002), 96.215);
        series1.add((RegularTimePeriod)new Day(1, 3, 2002), 96.015);
        series1.add((RegularTimePeriod)new Day(4, 3, 2002), 95.97);
        series1.add((RegularTimePeriod)new Day(5, 3, 2002), 95.935);
        series1.add((RegularTimePeriod)new Day(6, 3, 2002), 95.935);
        series1.add((RegularTimePeriod)new Day(7, 3, 2002), 95.705);
        series1.add((RegularTimePeriod)new Day(8, 3, 2002), 95.485);
        series1.add((RegularTimePeriod)new Day(11, 3, 2002), 95.505);
        series1.add((RegularTimePeriod)new Day(12, 3, 2002), 95.54);
        series1.add((RegularTimePeriod)new Day(13, 3, 2002), 95.675);
        series1.add((RegularTimePeriod)new Day(14, 3, 2002), 95.51);
        series1.add((RegularTimePeriod)new Day(15, 3, 2002), 95.5);
        series1.add((RegularTimePeriod)new Day(18, 3, 2002), 95.5);
        series1.add((RegularTimePeriod)new Day(19, 3, 2002), 95.535);
        series1.add((RegularTimePeriod)new Day(20, 3, 2002), 95.42);
        series1.add((RegularTimePeriod)new Day(21, 3, 2002), 95.4);
        series1.add((RegularTimePeriod)new Day(22, 3, 2002), 95.375);
        series1.add((RegularTimePeriod)new Day(25, 3, 2002), 95.35);
        series1.add((RegularTimePeriod)new Day(26, 3, 2002), 95.505);
        series1.add((RegularTimePeriod)new Day(27, 3, 2002), 95.55);
        series1.add((RegularTimePeriod)new Day(28, 3, 2002), 95.485);
        series1.add((RegularTimePeriod)new Day(1, 4, 2002), 95.485);
        series1.add((RegularTimePeriod)new Day(2, 4, 2002), 95.63);
        series1.add((RegularTimePeriod)new Day(3, 4, 2002), 95.735);
        series1.add((RegularTimePeriod)new Day(4, 4, 2002), 95.695);
        series1.add((RegularTimePeriod)new Day(5, 4, 2002), 95.81);
        series1.add((RegularTimePeriod)new Day(8, 4, 2002), 95.81);
        series1.add((RegularTimePeriod)new Day(9, 4, 2002), 95.865);
        series1.add((RegularTimePeriod)new Day(10, 4, 2002), 95.885);
        series1.add((RegularTimePeriod)new Day(11, 4, 2002), 95.9);
        series1.add((RegularTimePeriod)new Day(12, 4, 2002), 95.98);
        series1.add((RegularTimePeriod)new Day(15, 4, 2002), 96.035);
        series1.add((RegularTimePeriod)new Day(16, 4, 2002), 96.0);
        series1.add((RegularTimePeriod)new Day(17, 4, 2002), 96.035);
        series1.add((RegularTimePeriod)new Day(18, 4, 2002), 96.085);
        series1.add((RegularTimePeriod)new Day(19, 4, 2002), 96.075);
        series1.add((RegularTimePeriod)new Day(22, 4, 2002), 96.105);
        series1.add((RegularTimePeriod)new Day(23, 4, 2002), 96.075);
        series1.add((RegularTimePeriod)new Day(24, 4, 2002), 96.21);
        series1.add((RegularTimePeriod)new Day(25, 4, 2002), 96.255);
        series1.add((RegularTimePeriod)new Day(26, 4, 2002), 96.31);
        series1.add((RegularTimePeriod)new Day(29, 4, 2002), 96.31);
        series1.add((RegularTimePeriod)new Day(30, 4, 2002), 96.325);
        series1.add((RegularTimePeriod)new Day(1, 5, 2002), 96.345);
        series1.add((RegularTimePeriod)new Day(2, 5, 2002), 96.285);
        series1.add((RegularTimePeriod)new Day(3, 5, 2002), 96.385);
        series1.add((RegularTimePeriod)new Day(6, 5, 2002), 96.38);
        series1.add((RegularTimePeriod)new Day(7, 5, 2002), 96.485);
        series1.add((RegularTimePeriod)new Day(8, 5, 2002), 96.23);
        series1.add((RegularTimePeriod)new Day(9, 5, 2002), 96.31);
        series1.add((RegularTimePeriod)new Day(10, 5, 2002), 96.445);
        series1.add((RegularTimePeriod)new Day(13, 5, 2002), 96.355);
        series1.add((RegularTimePeriod)new Day(14, 5, 2002), 96.18);
        series1.add((RegularTimePeriod)new Day(15, 5, 2002), 96.24);
        series1.add((RegularTimePeriod)new Day(16, 5, 2002), 96.325);
        series1.add((RegularTimePeriod)new Day(17, 5, 2002), 96.2);
        series1.add((RegularTimePeriod)new Day(20, 5, 2002), 96.305);
        series1.add((RegularTimePeriod)new Day(21, 5, 2002), 96.385);
        series1.add((RegularTimePeriod)new Day(22, 5, 2002), 96.445);
        series1.add((RegularTimePeriod)new Day(23, 5, 2002), 96.385);
        series1.add((RegularTimePeriod)new Day(24, 5, 2002), 96.39);
        series1.add((RegularTimePeriod)new Day(28, 5, 2002), 96.39);
        series1.add((RegularTimePeriod)new Day(29, 5, 2002), 96.475);
        series1.add((RegularTimePeriod)new Day(30, 5, 2002), 96.555);
        series1.add((RegularTimePeriod)new Day(31, 5, 2002), 96.5);
        series1.add((RegularTimePeriod)new Day(3, 6, 2002), 96.54);
        series1.add((RegularTimePeriod)new Day(4, 6, 2002), 96.605);
        series1.add((RegularTimePeriod)new Day(5, 6, 2002), 96.58);
        series1.add((RegularTimePeriod)new Day(6, 6, 2002), 96.61);
        series1.add((RegularTimePeriod)new Day(7, 6, 2002), 96.6);
        series1.add((RegularTimePeriod)new Day(10, 6, 2002), 96.615);
        series1.add((RegularTimePeriod)new Day(11, 6, 2002), 96.705);
        series1.add((RegularTimePeriod)new Day(12, 6, 2002), 96.75);
        series1.add((RegularTimePeriod)new Day(13, 6, 2002), 96.83);
        series1.add((RegularTimePeriod)new Day(14, 6, 2002), 96.965);
        series1.add((RegularTimePeriod)new Day(17, 6, 2002), 96.945);
        series1.add((RegularTimePeriod)new Day(18, 6, 2002), 96.99);
        series1.add((RegularTimePeriod)new Day(19, 6, 2002), 97.165);
        series1.add((RegularTimePeriod)new Day(20, 6, 2002), 97.03);
        series1.add((RegularTimePeriod)new Day(21, 6, 2002), 97.145);
        series1.add((RegularTimePeriod)new Day(24, 6, 2002), 97.12);
        series1.add((RegularTimePeriod)new Day(25, 6, 2002), 97.175);
        series1.add((RegularTimePeriod)new Day(26, 6, 2002), 97.365);
        series1.add((RegularTimePeriod)new Day(27, 6, 2002), 97.245);
        series1.add((RegularTimePeriod)new Day(28, 6, 2002), 97.245);
        series1.add((RegularTimePeriod)new Day(1, 7, 2002), 97.29);
        series1.add((RegularTimePeriod)new Day(2, 7, 2002), 97.38);
        series1.add((RegularTimePeriod)new Day(3, 7, 2002), 97.38);
        series1.add((RegularTimePeriod)new Day(5, 7, 2002), 97.22);
        series1.add((RegularTimePeriod)new Day(8, 7, 2002), 97.325);
        series1.add((RegularTimePeriod)new Day(9, 7, 2002), 97.455);
        series1.add((RegularTimePeriod)new Day(10, 7, 2002), 97.58);
        series1.add((RegularTimePeriod)new Day(11, 7, 2002), 97.605);
        series1.add((RegularTimePeriod)new Day(12, 7, 2002), 97.69);
        series1.add((RegularTimePeriod)new Day(15, 7, 2002), 97.73);
        series1.add((RegularTimePeriod)new Day(16, 7, 2002), 97.58);
        series1.add((RegularTimePeriod)new Day(17, 7, 2002), 97.64);
        series1.add((RegularTimePeriod)new Day(18, 7, 2002), 97.68);
        series1.add((RegularTimePeriod)new Day(19, 7, 2002), 97.715);
        series1.add((RegularTimePeriod)new Day(22, 7, 2002), 97.815);
        series1.add((RegularTimePeriod)new Day(23, 7, 2002), 97.875);
        series1.add((RegularTimePeriod)new Day(24, 7, 2002), 97.835);
        series1.add((RegularTimePeriod)new Day(25, 7, 2002), 97.925);
        series1.add((RegularTimePeriod)new Day(26, 7, 2002), 97.96);
        series1.add((RegularTimePeriod)new Day(29, 7, 2002), 97.745);
        series1.add((RegularTimePeriod)new Day(30, 7, 2002), 97.71);
        series1.add((RegularTimePeriod)new Day(31, 7, 2002), 97.93);
        series1.add((RegularTimePeriod)new Day(1, 8, 2002), 98.0);
        series1.add((RegularTimePeriod)new Day(2, 8, 2002), 98.17);
        series1.add((RegularTimePeriod)new Day(5, 8, 2002), 98.225);
        series1.add((RegularTimePeriod)new Day(6, 8, 2002), 98.115);
        series1.add((RegularTimePeriod)new Day(7, 8, 2002), 98.265);
        series1.add((RegularTimePeriod)new Day(8, 8, 2002), 98.18);
        series1.add((RegularTimePeriod)new Day(9, 8, 2002), 98.185);
        series1.add((RegularTimePeriod)new Day(12, 8, 2002), 98.15);
        series1.add((RegularTimePeriod)new Day(13, 8, 2002), 98.29);
        series1.add((RegularTimePeriod)new Day(14, 8, 2002), 98.155);
        series1.add((RegularTimePeriod)new Day(15, 8, 2002), 98.075);
        series1.add((RegularTimePeriod)new Day(16, 8, 2002), 98.0);
        series1.add((RegularTimePeriod)new Day(19, 8, 2002), 98.04);
        series1.add((RegularTimePeriod)new Day(20, 8, 2002), 98.135);
        series1.add((RegularTimePeriod)new Day(21, 8, 2002), 98.11);
        series1.add((RegularTimePeriod)new Day(22, 8, 2002), 98.005);
        series1.add((RegularTimePeriod)new Day(23, 8, 2002), 98.055);
        series1.add((RegularTimePeriod)new Day(26, 8, 2002), 98.065);
        series1.add((RegularTimePeriod)new Day(27, 8, 2002), 97.98);
        series1.add((RegularTimePeriod)new Day(28, 8, 2002), 98.035);
        series1.add((RegularTimePeriod)new Day(29, 8, 2002), 98.095);
        series1.add((RegularTimePeriod)new Day(30, 8, 2002), 98.06);
        series1.add((RegularTimePeriod)new Day(3, 9, 2002), 98.25);
        series1.add((RegularTimePeriod)new Day(4, 9, 2002), 98.245);
        series1.add((RegularTimePeriod)new Day(5, 9, 2002), 98.315);
        series1.add((RegularTimePeriod)new Day(6, 9, 2002), 98.17);
        series1.add((RegularTimePeriod)new Day(9, 9, 2002), 98.08);
        series1.add((RegularTimePeriod)new Day(10, 9, 2002), 98.09);
        series1.add((RegularTimePeriod)new Day(11, 9, 2002), 98.03);
        series1.add((RegularTimePeriod)new Day(12, 9, 2002), 98.105);
        series1.add((RegularTimePeriod)new Day(13, 9, 2002), 98.135);
        series1.add((RegularTimePeriod)new Day(16, 9, 2002), 98.115);
        series1.add((RegularTimePeriod)new Day(17, 9, 2002), 98.125);
        series1.add((RegularTimePeriod)new Day(18, 9, 2002), 98.13);
        series1.add((RegularTimePeriod)new Day(19, 9, 2002), 98.255);
        series1.add((RegularTimePeriod)new Day(20, 9, 2002), 98.255);
        series1.add((RegularTimePeriod)new Day(23, 9, 2002), 98.28);
        series1.add((RegularTimePeriod)new Day(24, 9, 2002), 98.31);
        series1.add((RegularTimePeriod)new Day(25, 9, 2002), 98.25);
        series1.add((RegularTimePeriod)new Day(26, 9, 2002), 98.3);
        series1.add((RegularTimePeriod)new Day(27, 9, 2002), 98.41);
        series1.add((RegularTimePeriod)new Day(30, 9, 2002), 98.495);
        series1.add((RegularTimePeriod)new Day(1, 10, 2002), 98.44);
        series1.add((RegularTimePeriod)new Day(2, 10, 2002), 98.44);
        series1.add((RegularTimePeriod)new Day(3, 10, 2002), 98.44);
        series1.add((RegularTimePeriod)new Day(4, 10, 2002), 98.38);
        series1.add((RegularTimePeriod)new Day(7, 10, 2002), 98.385);
        series1.add((RegularTimePeriod)new Day(8, 10, 2002), 98.34);
        series1.add((RegularTimePeriod)new Day(9, 10, 2002), 98.42);
        series1.add((RegularTimePeriod)new Day(10, 10, 2002), 98.375);
        series1.add((RegularTimePeriod)new Day(11, 10, 2002), 98.275);
        series1.add((RegularTimePeriod)new Day(14, 10, 2002), 98.275);
        series1.add((RegularTimePeriod)new Day(15, 10, 2002), 98.135);
        series1.add((RegularTimePeriod)new Day(16, 10, 2002), 98.165);
        series1.add((RegularTimePeriod)new Day(17, 10, 2002), 98.17);
        series1.add((RegularTimePeriod)new Day(18, 10, 2002), 98.165);
        series1.add((RegularTimePeriod)new Day(21, 10, 2002), 98.105);
        series1.add((RegularTimePeriod)new Day(22, 10, 2002), 98.125);
        series1.add((RegularTimePeriod)new Day(23, 10, 2002), 98.185);
        series1.add((RegularTimePeriod)new Day(24, 10, 2002), 98.245);
        series1.add((RegularTimePeriod)new Day(25, 10, 2002), 98.32);
        series1.add((RegularTimePeriod)new Day(28, 10, 2002), 98.42);
        series1.add((RegularTimePeriod)new Day(29, 10, 2002), 98.54);
        series1.add((RegularTimePeriod)new Day(30, 10, 2002), 98.545);
        series1.add((RegularTimePeriod)new Day(31, 10, 2002), 98.56);
        return new TimeSeriesCollection(series1);
    }

    private IntervalXYDataset createVolumeDataset() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series1 = new TimeSeries("Volume", clazz);
        series1.add((RegularTimePeriod)new Day(2, 1, 2002), 41020.0);
        series1.add((RegularTimePeriod)new Day(3, 1, 2002), 45586.0);
        series1.add((RegularTimePeriod)new Day(4, 1, 2002), 81672.0);
        series1.add((RegularTimePeriod)new Day(7, 1, 2002), 81975.0);
        series1.add((RegularTimePeriod)new Day(8, 1, 2002), 79692.0);
        series1.add((RegularTimePeriod)new Day(9, 1, 2002), 53187.0);
        series1.add((RegularTimePeriod)new Day(10, 1, 2002), 87929.0);
        series1.add((RegularTimePeriod)new Day(11, 1, 2002), 107047.0);
        series1.add((RegularTimePeriod)new Day(14, 1, 2002), 86276.0);
        series1.add((RegularTimePeriod)new Day(15, 1, 2002), 79005.0);
        series1.add((RegularTimePeriod)new Day(16, 1, 2002), 80632.0);
        series1.add((RegularTimePeriod)new Day(17, 1, 2002), 88797.0);
        series1.add((RegularTimePeriod)new Day(18, 1, 2002), 57179.0);
        series1.add((RegularTimePeriod)new Day(22, 1, 2002), 36611.0);
        series1.add((RegularTimePeriod)new Day(23, 1, 2002), 57063.0);
        series1.add((RegularTimePeriod)new Day(24, 1, 2002), 101938.0);
        series1.add((RegularTimePeriod)new Day(25, 1, 2002), 87177.0);
        series1.add((RegularTimePeriod)new Day(28, 1, 2002), 39831.0);
        series1.add((RegularTimePeriod)new Day(29, 1, 2002), 67654.0);
        series1.add((RegularTimePeriod)new Day(30, 1, 2002), 81162.0);
        series1.add((RegularTimePeriod)new Day(31, 1, 2002), 64923.0);
        series1.add((RegularTimePeriod)new Day(1, 2, 2002), 73481.0);
        series1.add((RegularTimePeriod)new Day(4, 2, 2002), 54723.0);
        series1.add((RegularTimePeriod)new Day(5, 2, 2002), 76708.0);
        series1.add((RegularTimePeriod)new Day(6, 2, 2002), 81281.0);
        series1.add((RegularTimePeriod)new Day(7, 2, 2002), 66553.0);
        series1.add((RegularTimePeriod)new Day(8, 2, 2002), 53592.0);
        series1.add((RegularTimePeriod)new Day(11, 2, 2002), 29410.0);
        series1.add((RegularTimePeriod)new Day(12, 2, 2002), 60345.0);
        series1.add((RegularTimePeriod)new Day(13, 2, 2002), 67339.0);
        series1.add((RegularTimePeriod)new Day(14, 2, 2002), 40057.0);
        series1.add((RegularTimePeriod)new Day(15, 2, 2002), 67865.0);
        series1.add((RegularTimePeriod)new Day(19, 2, 2002), 58628.0);
        series1.add((RegularTimePeriod)new Day(20, 2, 2002), 52109.0);
        series1.add((RegularTimePeriod)new Day(21, 2, 2002), 50195.0);
        series1.add((RegularTimePeriod)new Day(22, 2, 2002), 47806.0);
        series1.add((RegularTimePeriod)new Day(25, 2, 2002), 31711.0);
        series1.add((RegularTimePeriod)new Day(26, 2, 2002), 88328.0);
        series1.add((RegularTimePeriod)new Day(27, 2, 2002), 95805.0);
        series1.add((RegularTimePeriod)new Day(28, 2, 2002), 84035.0);
        series1.add((RegularTimePeriod)new Day(1, 3, 2002), 113584.0);
        series1.add((RegularTimePeriod)new Day(4, 3, 2002), 71872.0);
        series1.add((RegularTimePeriod)new Day(5, 3, 2002), 83016.0);
        series1.add((RegularTimePeriod)new Day(6, 3, 2002), 62273.0);
        series1.add((RegularTimePeriod)new Day(7, 3, 2002), 138508.0);
        series1.add((RegularTimePeriod)new Day(8, 3, 2002), 139428.0);
        series1.add((RegularTimePeriod)new Day(11, 3, 2002), 80232.0);
        series1.add((RegularTimePeriod)new Day(12, 3, 2002), 75693.0);
        series1.add((RegularTimePeriod)new Day(13, 3, 2002), 104068.0);
        series1.add((RegularTimePeriod)new Day(14, 3, 2002), 72171.0);
        series1.add((RegularTimePeriod)new Day(15, 3, 2002), 117262.0);
        series1.add((RegularTimePeriod)new Day(18, 3, 2002), 66048.0);
        series1.add((RegularTimePeriod)new Day(19, 3, 2002), 87079.0);
        series1.add((RegularTimePeriod)new Day(20, 3, 2002), 116084.0);
        series1.add((RegularTimePeriod)new Day(21, 3, 2002), 113206.0);
        series1.add((RegularTimePeriod)new Day(22, 3, 2002), 68326.0);
        series1.add((RegularTimePeriod)new Day(25, 3, 2002), 34340.0);
        series1.add((RegularTimePeriod)new Day(26, 3, 2002), 104413.0);
        series1.add((RegularTimePeriod)new Day(27, 3, 2002), 57277.0);
        series1.add((RegularTimePeriod)new Day(28, 3, 2002), 69936.0);
        series1.add((RegularTimePeriod)new Day(1, 4, 2002), 57282.0);
        series1.add((RegularTimePeriod)new Day(2, 4, 2002), 74686.0);
        series1.add((RegularTimePeriod)new Day(3, 4, 2002), 108601.0);
        series1.add((RegularTimePeriod)new Day(4, 4, 2002), 123381.0);
        series1.add((RegularTimePeriod)new Day(5, 4, 2002), 106691.0);
        series1.add((RegularTimePeriod)new Day(8, 4, 2002), 118535.0);
        series1.add((RegularTimePeriod)new Day(9, 4, 2002), 85577.0);
        series1.add((RegularTimePeriod)new Day(10, 4, 2002), 75441.0);
        series1.add((RegularTimePeriod)new Day(11, 4, 2002), 88845.0);
        series1.add((RegularTimePeriod)new Day(12, 4, 2002), 137141.0);
        series1.add((RegularTimePeriod)new Day(15, 4, 2002), 72518.0);
        series1.add((RegularTimePeriod)new Day(16, 4, 2002), 122100.0);
        series1.add((RegularTimePeriod)new Day(17, 4, 2002), 136419.0);
        series1.add((RegularTimePeriod)new Day(18, 4, 2002), 141338.0);
        series1.add((RegularTimePeriod)new Day(19, 4, 2002), 80274.0);
        series1.add((RegularTimePeriod)new Day(22, 4, 2002), 40449.0);
        series1.add((RegularTimePeriod)new Day(23, 4, 2002), 72292.0);
        series1.add((RegularTimePeriod)new Day(24, 4, 2002), 110644.0);
        series1.add((RegularTimePeriod)new Day(25, 4, 2002), 145142.0);
        series1.add((RegularTimePeriod)new Day(26, 4, 2002), 139573.0);
        series1.add((RegularTimePeriod)new Day(29, 4, 2002), 51509.0);
        series1.add((RegularTimePeriod)new Day(30, 4, 2002), 105782.0);
        series1.add((RegularTimePeriod)new Day(1, 5, 2002), 170680.0);
        series1.add((RegularTimePeriod)new Day(2, 5, 2002), 140800.0);
        series1.add((RegularTimePeriod)new Day(3, 5, 2002), 170411.0);
        series1.add((RegularTimePeriod)new Day(6, 5, 2002), 46172.0);
        series1.add((RegularTimePeriod)new Day(7, 5, 2002), 137251.0);
        series1.add((RegularTimePeriod)new Day(8, 5, 2002), 220626.0);
        series1.add((RegularTimePeriod)new Day(9, 5, 2002), 175902.0);
        series1.add((RegularTimePeriod)new Day(10, 5, 2002), 128807.0);
        series1.add((RegularTimePeriod)new Day(13, 5, 2002), 78208.0);
        series1.add((RegularTimePeriod)new Day(14, 5, 2002), 212048.0);
        series1.add((RegularTimePeriod)new Day(15, 5, 2002), 145643.0);
        series1.add((RegularTimePeriod)new Day(16, 5, 2002), 121520.0);
        series1.add((RegularTimePeriod)new Day(17, 5, 2002), 147820.0);
        series1.add((RegularTimePeriod)new Day(20, 5, 2002), 75969.0);
        series1.add((RegularTimePeriod)new Day(21, 5, 2002), 118970.0);
        series1.add((RegularTimePeriod)new Day(22, 5, 2002), 131013.0);
        series1.add((RegularTimePeriod)new Day(23, 5, 2002), 141100.0);
        series1.add((RegularTimePeriod)new Day(24, 5, 2002), 63606.0);
        series1.add((RegularTimePeriod)new Day(28, 5, 2002), 78687.0);
        series1.add((RegularTimePeriod)new Day(29, 5, 2002), 86743.0);
        series1.add((RegularTimePeriod)new Day(30, 5, 2002), 164376.0);
        series1.add((RegularTimePeriod)new Day(31, 5, 2002), 150108.0);
        series1.add((RegularTimePeriod)new Day(3, 6, 2002), 132363.0);
        series1.add((RegularTimePeriod)new Day(4, 6, 2002), 144902.0);
        series1.add((RegularTimePeriod)new Day(5, 6, 2002), 123834.0);
        series1.add((RegularTimePeriod)new Day(6, 6, 2002), 125004.0);
        series1.add((RegularTimePeriod)new Day(7, 6, 2002), 165049.0);
        series1.add((RegularTimePeriod)new Day(10, 6, 2002), 88069.0);
        series1.add((RegularTimePeriod)new Day(11, 6, 2002), 114146.0);
        series1.add((RegularTimePeriod)new Day(12, 6, 2002), 149992.0);
        series1.add((RegularTimePeriod)new Day(13, 6, 2002), 191261.0);
        series1.add((RegularTimePeriod)new Day(14, 6, 2002), 207444.0);
        series1.add((RegularTimePeriod)new Day(17, 6, 2002), 117081.0);
        series1.add((RegularTimePeriod)new Day(18, 6, 2002), 135924.0);
        series1.add((RegularTimePeriod)new Day(19, 6, 2002), 179654.0);
        series1.add((RegularTimePeriod)new Day(20, 6, 2002), 260936.0);
        series1.add((RegularTimePeriod)new Day(21, 6, 2002), 140283.0);
        series1.add((RegularTimePeriod)new Day(24, 6, 2002), 199052.0);
        series1.add((RegularTimePeriod)new Day(25, 6, 2002), 191804.0);
        series1.add((RegularTimePeriod)new Day(26, 6, 2002), 384936.0);
        series1.add((RegularTimePeriod)new Day(27, 6, 2002), 313065.0);
        series1.add((RegularTimePeriod)new Day(28, 6, 2002), 169963.0);
        series1.add((RegularTimePeriod)new Day(1, 7, 2002), 109906.0);
        series1.add((RegularTimePeriod)new Day(2, 7, 2002), 140644.0);
        series1.add((RegularTimePeriod)new Day(3, 7, 2002), 150898.0);
        series1.add((RegularTimePeriod)new Day(5, 7, 2002), 181355.0);
        series1.add((RegularTimePeriod)new Day(8, 7, 2002), 155042.0);
        series1.add((RegularTimePeriod)new Day(9, 7, 2002), 204305.0);
        series1.add((RegularTimePeriod)new Day(10, 7, 2002), 300113.0);
        series1.add((RegularTimePeriod)new Day(11, 7, 2002), 338948.0);
        series1.add((RegularTimePeriod)new Day(12, 7, 2002), 281325.0);
        series1.add((RegularTimePeriod)new Day(15, 7, 2002), 256101.0);
        series1.add((RegularTimePeriod)new Day(16, 7, 2002), 348164.0);
        series1.add((RegularTimePeriod)new Day(17, 7, 2002), 242995.0);
        series1.add((RegularTimePeriod)new Day(18, 7, 2002), 200744.0);
        series1.add((RegularTimePeriod)new Day(19, 7, 2002), 181071.0);
        series1.add((RegularTimePeriod)new Day(22, 7, 2002), 163266.0);
        series1.add((RegularTimePeriod)new Day(23, 7, 2002), 188508.0);
        series1.add((RegularTimePeriod)new Day(24, 7, 2002), 308070.0);
        series1.add((RegularTimePeriod)new Day(25, 7, 2002), 230901.0);
        series1.add((RegularTimePeriod)new Day(26, 7, 2002), 162577.0);
        series1.add((RegularTimePeriod)new Day(29, 7, 2002), 216318.0);
        series1.add((RegularTimePeriod)new Day(30, 7, 2002), 280677.0);
        series1.add((RegularTimePeriod)new Day(31, 7, 2002), 260236.0);
        series1.add((RegularTimePeriod)new Day(1, 8, 2002), 242803.0);
        series1.add((RegularTimePeriod)new Day(2, 8, 2002), 298490.0);
        series1.add((RegularTimePeriod)new Day(5, 8, 2002), 182890.0);
        series1.add((RegularTimePeriod)new Day(6, 8, 2002), 232273.0);
        series1.add((RegularTimePeriod)new Day(7, 8, 2002), 253552.0);
        series1.add((RegularTimePeriod)new Day(8, 8, 2002), 165365.0);
        series1.add((RegularTimePeriod)new Day(9, 8, 2002), 160382.0);
        series1.add((RegularTimePeriod)new Day(12, 8, 2002), 118030.0);
        series1.add((RegularTimePeriod)new Day(13, 8, 2002), 208807.0);
        series1.add((RegularTimePeriod)new Day(14, 8, 2002), 231599.0);
        series1.add((RegularTimePeriod)new Day(15, 8, 2002), 343482.0);
        series1.add((RegularTimePeriod)new Day(16, 8, 2002), 186116.0);
        series1.add((RegularTimePeriod)new Day(19, 8, 2002), 96437.0);
        series1.add((RegularTimePeriod)new Day(20, 8, 2002), 151735.0);
        series1.add((RegularTimePeriod)new Day(21, 8, 2002), 167390.0);
        series1.add((RegularTimePeriod)new Day(22, 8, 2002), 127184.0);
        series1.add((RegularTimePeriod)new Day(23, 8, 2002), 80205.0);
        series1.add((RegularTimePeriod)new Day(26, 8, 2002), 79893.0);
        series1.add((RegularTimePeriod)new Day(27, 8, 2002), 201723.0);
        series1.add((RegularTimePeriod)new Day(28, 8, 2002), 114001.0);
        series1.add((RegularTimePeriod)new Day(29, 8, 2002), 188389.0);
        series1.add((RegularTimePeriod)new Day(30, 8, 2002), 162801.0);
        series1.add((RegularTimePeriod)new Day(3, 9, 2002), 200951.0);
        series1.add((RegularTimePeriod)new Day(4, 9, 2002), 129229.0);
        series1.add((RegularTimePeriod)new Day(5, 9, 2002), 183348.0);
        series1.add((RegularTimePeriod)new Day(6, 9, 2002), 216722.0);
        series1.add((RegularTimePeriod)new Day(9, 9, 2002), 128575.0);
        series1.add((RegularTimePeriod)new Day(10, 9, 2002), 224714.0);
        series1.add((RegularTimePeriod)new Day(11, 9, 2002), 144224.0);
        series1.add((RegularTimePeriod)new Day(12, 9, 2002), 195721.0);
        series1.add((RegularTimePeriod)new Day(13, 9, 2002), 160724.0);
        series1.add((RegularTimePeriod)new Day(16, 9, 2002), 65473.0);
        series1.add((RegularTimePeriod)new Day(17, 9, 2002), 141274.0);
        series1.add((RegularTimePeriod)new Day(18, 9, 2002), 115084.0);
        series1.add((RegularTimePeriod)new Day(19, 9, 2002), 242106.0);
        series1.add((RegularTimePeriod)new Day(20, 9, 2002), 130034.0);
        series1.add((RegularTimePeriod)new Day(23, 9, 2002), 95215.0);
        series1.add((RegularTimePeriod)new Day(24, 9, 2002), 229288.0);
        series1.add((RegularTimePeriod)new Day(25, 9, 2002), 163672.0);
        series1.add((RegularTimePeriod)new Day(26, 9, 2002), 193573.0);
        series1.add((RegularTimePeriod)new Day(27, 9, 2002), 170741.0);
        series1.add((RegularTimePeriod)new Day(30, 9, 2002), 199615.0);
        series1.add((RegularTimePeriod)new Day(1, 10, 2002), 170771.0);
        series1.add((RegularTimePeriod)new Day(2, 10, 2002), 138498.0);
        series1.add((RegularTimePeriod)new Day(3, 10, 2002), 154774.0);
        series1.add((RegularTimePeriod)new Day(4, 10, 2002), 287154.0);
        series1.add((RegularTimePeriod)new Day(7, 10, 2002), 111762.0);
        series1.add((RegularTimePeriod)new Day(8, 10, 2002), 172535.0);
        series1.add((RegularTimePeriod)new Day(9, 10, 2002), 148339.0);
        series1.add((RegularTimePeriod)new Day(10, 10, 2002), 178796.0);
        series1.add((RegularTimePeriod)new Day(11, 10, 2002), 153499.0);
        series1.add((RegularTimePeriod)new Day(14, 10, 2002), 4589.0);
        series1.add((RegularTimePeriod)new Day(15, 10, 2002), 172088.0);
        series1.add((RegularTimePeriod)new Day(16, 10, 2002), 151267.0);
        series1.add((RegularTimePeriod)new Day(17, 10, 2002), 222680.0);
        series1.add((RegularTimePeriod)new Day(18, 10, 2002), 127019.0);
        series1.add((RegularTimePeriod)new Day(21, 10, 2002), 118226.0);
        series1.add((RegularTimePeriod)new Day(22, 10, 2002), 183031.0);
        series1.add((RegularTimePeriod)new Day(23, 10, 2002), 221005.0);
        series1.add((RegularTimePeriod)new Day(24, 10, 2002), 121333.0);
        series1.add((RegularTimePeriod)new Day(25, 10, 2002), 138179.0);
        series1.add((RegularTimePeriod)new Day(28, 10, 2002), 162012.0);
        series1.add((RegularTimePeriod)new Day(29, 10, 2002), 237355.0);
        series1.add((RegularTimePeriod)new Day(30, 10, 2002), 161650.0);
        series1.add((RegularTimePeriod)new Day(31, 10, 2002), 207569.0);
        return new TimeSeriesCollection(series1);
    }

    public static void main(String[] args) {
        PriceVolumeDemo demo = new PriceVolumeDemo("Price Volume Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

