/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import org.jfree.data.AbstractXYDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.XYDataset;

public class SampleXYDataset
extends AbstractXYDataset
implements XYDataset {
    private double translate = 0.0;

    public double getTranslate() {
        return this.translate;
    }

    public void setTranslate(double translate) {
        this.translate = translate;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public Number getXValue(int series, int item) {
        return new Double(-10.0 + this.translate + (double)item / 10.0);
    }

    public Number getYValue(int series, int item) {
        if (series == 0) {
            return new Double(Math.cos(-10.0 + this.translate + (double)item / 10.0));
        }
        return new Double(2.0 * Math.sin(-10.0 + this.translate + (double)item / 10.0));
    }

    public int getSeriesCount() {
        return 2;
    }

    public String getSeriesName(int series) {
        if (series == 0) {
            return "y = cosine(x)";
        }
        if (series == 1) {
            return "y = 2*sine(x)";
        }
        return "Error";
    }

    public int getItemCount(int series) {
        return 200;
    }
}

