/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import org.jfree.data.AbstractXYDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.XYDataset;

public class SampleXYDataset2
extends AbstractXYDataset
implements XYDataset,
DomainInfo,
RangeInfo {
    private static final int DEFAULT_SERIES_COUNT = 4;
    private static final int DEFAULT_ITEM_COUNT = 100;
    private static final double DEFAULT_RANGE = 200.0;
    private Double[][] xValues;
    private Double[][] yValues;
    private int seriesCount;
    private int itemCount;
    private Number domainMin;
    private Number domainMax;
    private Number rangeMin;
    private Number rangeMax;
    private Range domainRange;
    private Range range;

    public SampleXYDataset2() {
        this(4, 100);
    }

    public SampleXYDataset2(int seriesCount, int itemCount) {
        this.xValues = new Double[seriesCount][itemCount];
        this.yValues = new Double[seriesCount][itemCount];
        this.seriesCount = seriesCount;
        this.itemCount = itemCount;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        int series = 0;
        while (series < seriesCount) {
            int item = 0;
            while (item < itemCount) {
                double x = (Math.random() - 0.5) * 200.0;
                this.xValues[series][item] = new Double(x);
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                double y = (Math.random() + 0.5) * 6.0 * x + x;
                this.yValues[series][item] = new Double(y);
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                ++item;
            }
            ++series;
        }
        this.domainMin = new Double(minX);
        this.domainMax = new Double(maxX);
        this.domainRange = new Range(minX, maxX);
        this.rangeMin = new Double(minY);
        this.rangeMax = new Double(maxY);
        this.range = new Range(minY, maxY);
    }

    public Number getXValue(int series, int item) {
        return this.xValues[series][item];
    }

    public Number getYValue(int series, int item) {
        return this.yValues[series][item];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int series) {
        return "Sample " + series;
    }

    public int getItemCount(int series) {
        return this.itemCount;
    }

    public Number getMinimumDomainValue() {
        return this.domainMin;
    }

    public Number getMaximumDomainValue() {
        return this.domainMax;
    }

    public Range getDomainRange() {
        return this.domainRange;
    }

    public Number getMinimumRangeValue() {
        return this.rangeMin;
    }

    public Number getMaximumRangeValue() {
        return this.rangeMax;
    }

    public Range getValueRange() {
        return this.range;
    }
}

