/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.lang.reflect.Array;
import java.util.Vector;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;

public class SampleXYSymbolicDataset
extends AbstractSeriesDataset
implements XYDataset,
XisSymbolic,
YisSymbolic {
    private String[] seriesName;
    private int[] item;
    private int serie;
    private Integer[][] xValues;
    private Integer[][] yValues;
    private String[] xSymbolicValues;
    private String[] ySymbolicValues;
    private String datasetName;

    public SampleXYSymbolicDataset(String datasetName, Integer[][] xValues, Integer[][] yValues, String[] xSymbolicValues, String[] ySymbolicValues, String[] seriesName) {
        this.datasetName = datasetName;
        this.xValues = xValues;
        this.yValues = yValues;
        this.xSymbolicValues = xSymbolicValues;
        this.ySymbolicValues = ySymbolicValues;
        this.serie = xValues.length;
        this.item = new int[this.serie];
        int i = 0;
        while (i < this.serie) {
            this.item[i] = xValues[i].length;
            ++i;
        }
        this.seriesName = seriesName;
    }

    public Number getXValue(int series, int item) {
        return this.xValues[series][item];
    }

    public double getX(int series, int item) {
        double result = Double.NaN;
        Number x = this.getXValue(series, item);
        if (x != null) {
            result = x.doubleValue();
        }
        return result;
    }

    public Number getYValue(int series, int item) {
        return this.yValues[series][item];
    }

    public double getY(int series, int item) {
        double result = Double.NaN;
        Number y = this.getYValue(series, item);
        if (y != null) {
            result = y.doubleValue();
        }
        return result;
    }

    public void setXValue(int series, int item, Number newValue) {
        this.xValues[series][item] = (Integer)newValue;
    }

    public void setYValue(int series, int item, Number newValue) {
        this.yValues[series][item] = (Integer)newValue;
    }

    public int getSeriesCount() {
        return this.serie;
    }

    public String getSeriesName(int series) {
        if (this.seriesName != null) {
            return this.seriesName[series];
        }
        return String.valueOf(this.datasetName) + series;
    }

    public int getItemCount(int series) {
        return this.item[series];
    }

    public String[] getXSymbolicValues() {
        return this.xSymbolicValues;
    }

    public String[] getYSymbolicValues() {
        return this.ySymbolicValues;
    }

    public void setXSymbolicValues(String[] sValues) {
        this.xSymbolicValues = sValues;
    }

    public void setYSymbolicValues(String[] sValues) {
        this.ySymbolicValues = sValues;
    }

    public String getXSymbolicValue(int series, int item) {
        Integer intValue = (Integer)this.getXValue(series, item);
        return this.getXSymbolicValue(intValue);
    }

    public String getYSymbolicValue(int series, int item) {
        Integer intValue = (Integer)this.getYValue(series, item);
        return this.getYSymbolicValue(intValue);
    }

    public String getXSymbolicValue(Integer val) {
        return this.xSymbolicValues[val];
    }

    public String getYSymbolicValue(Integer val) {
        return this.ySymbolicValues[val];
    }

    public static String[] combineYSymbolicDataset(YisSymbolic dataset1, YisSymbolic dataset2) {
        SampleXYSymbolicDataset sDataset1 = (SampleXYSymbolicDataset)dataset1;
        SampleXYSymbolicDataset sDataset2 = (SampleXYSymbolicDataset)dataset2;
        String[] sDatasetSymbolicValues1 = sDataset1.getYSymbolicValues();
        String[] sDatasetSymbolicValues2 = sDataset2.getYSymbolicValues();
        int s1length = sDatasetSymbolicValues1.length;
        int s2length = sDatasetSymbolicValues2.length;
        Vector<String> ySymbolicValuesCombined = new Vector<String>();
        int i = 0;
        while (i < s1length) {
            ySymbolicValuesCombined.add(sDatasetSymbolicValues1[i]);
            ++i;
        }
        i = 0;
        while (i < s2length) {
            if (!ySymbolicValuesCombined.contains(sDatasetSymbolicValues2[i])) {
                ySymbolicValuesCombined.add(sDatasetSymbolicValues2[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < sDataset2.getSeriesCount()) {
            int j = 0;
            while (j < sDataset2.getItemCount(i2)) {
                int newIndex = ySymbolicValuesCombined.indexOf(sDataset2.getYSymbolicValue(i2, j));
                sDataset2.setYValue(i2, j, new Integer(newIndex));
                ++j;
            }
            ++i2;
        }
        String[] ySymbolicValuesCombinedA = new String[ySymbolicValuesCombined.size()];
        ySymbolicValuesCombined.toArray(ySymbolicValuesCombinedA);
        sDataset1.setYSymbolicValues(ySymbolicValuesCombinedA);
        sDataset2.setYSymbolicValues(ySymbolicValuesCombinedA);
        return ySymbolicValuesCombinedA;
    }

    public static String[] combineXSymbolicDataset(XisSymbolic dataset1, XisSymbolic dataset2) {
        SampleXYSymbolicDataset sDataset1 = (SampleXYSymbolicDataset)dataset1;
        SampleXYSymbolicDataset sDataset2 = (SampleXYSymbolicDataset)dataset2;
        String[] sDatasetSymbolicValues1 = sDataset1.getXSymbolicValues();
        String[] sDatasetSymbolicValues2 = sDataset2.getXSymbolicValues();
        int s1length = sDatasetSymbolicValues1.length;
        int s2length = sDatasetSymbolicValues2.length;
        Vector<String> xSymbolicValuesCombined = new Vector<String>();
        int i = 0;
        while (i < s1length) {
            xSymbolicValuesCombined.add(sDatasetSymbolicValues1[i]);
            ++i;
        }
        i = 0;
        while (i < s2length) {
            if (!xSymbolicValuesCombined.contains(sDatasetSymbolicValues2[i])) {
                xSymbolicValuesCombined.add(sDatasetSymbolicValues2[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < sDataset2.getSeriesCount()) {
            int j = 0;
            while (j < sDataset2.getItemCount(i2)) {
                int newIndex = xSymbolicValuesCombined.indexOf(sDataset2.getXSymbolicValue(i2, j));
                sDataset2.setXValue(i2, j, new Integer(newIndex));
                ++j;
            }
            ++i2;
        }
        String[] xSymbolicValuesCombinedA = new String[xSymbolicValuesCombined.size()];
        xSymbolicValuesCombined.toArray(xSymbolicValuesCombinedA);
        sDataset1.setXSymbolicValues(xSymbolicValuesCombinedA);
        sDataset2.setXSymbolicValues(xSymbolicValuesCombinedA);
        return xSymbolicValuesCombinedA;
    }

    public Object clone() {
        String nDatasetName = new String(this.datasetName);
        Integer[][] nXValues = (Integer[][])SampleXYSymbolicDataset.cloneArray(this.xValues);
        Integer[][] nYValues = (Integer[][])SampleXYSymbolicDataset.cloneArray(this.yValues);
        String[] nXSymbolicValues = (String[])SampleXYSymbolicDataset.cloneArray(this.xSymbolicValues);
        String[] nYSymbolicValues = (String[])SampleXYSymbolicDataset.cloneArray(this.ySymbolicValues);
        String[] sName = (String[])SampleXYSymbolicDataset.cloneArray(this.seriesName);
        return new SampleXYSymbolicDataset(nDatasetName, nXValues, nYValues, nXSymbolicValues, nYSymbolicValues, sName);
    }

    private static Object cloneArray(Object arr) {
        if (arr == null) {
            return arr;
        }
        Class<?> cls = arr.getClass();
        if (!cls.isArray()) {
            return arr;
        }
        int length = Array.getLength(arr);
        Object[] newarr = (Object[])Array.newInstance(cls.getComponentType(), length);
        int i = 0;
        while (i < length) {
            Object obj = Array.get(arr, i);
            newarr[i] = obj.getClass().isArray() ? SampleXYSymbolicDataset.cloneArray(obj) : obj;
            ++i;
        }
        return newarr;
    }
}

