/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.SampleXYDataset2;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ScatterPlotDemo
extends ApplicationFrame {
    public ScatterPlotDemo(String title) {
        super(title);
        SampleXYDataset2 data = new SampleXYDataset2();
        JFreeChart chart = ChartFactory.createScatterPlot("Scatter Plot Demo", "X", "Y", data, PlotOrientation.VERTICAL, true, true, false);
        Legend legend = chart.getLegend();
        if (legend instanceof StandardLegend) {
            StandardLegend sl = (StandardLegend)legend;
            sl.setDisplaySeriesShapes(true);
        }
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setNoDataMessage("NO DATA");
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setVerticalAxisTrace(true);
        chartPanel.setHorizontalAxisTrace(true);
        chartPanel.setVerticalZoom(true);
        chartPanel.setHorizontalZoom(true);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        ScatterPlotDemo demo = new ScatterPlotDemo("Scatter Plot Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

