/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.SampleXYDataset2;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ScatterPlotDemo3
extends ApplicationFrame
implements ChartMouseListener {
    private ChartPanel chartPanel;

    public ScatterPlotDemo3(String title) {
        super(title);
        SampleXYDataset2 dataset = new SampleXYDataset2();
        JFreeChart chart = this.createChart(dataset);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.addChartMouseListener(this);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.chartPanel.setVerticalAxisTrace(true);
        this.chartPanel.setHorizontalAxisTrace(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setHorizontalZoom(true);
        this.setContentPane(this.chartPanel);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createScatterPlot("Scatter Plot Demo", "X", "Y", dataset, PlotOrientation.VERTICAL, true, true, false);
        Legend legend = chart.getLegend();
        if (legend instanceof StandardLegend) {
            StandardLegend sl = (StandardLegend)legend;
            sl.setDisplaySeriesShapes(true);
        }
        NumberAxis domainAxis = (NumberAxis)chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        int x = event.getTrigger().getX();
        int y = event.getTrigger().getY();
        Point2D p = this.chartPanel.translateScreenToJava2D(new Point(x, y));
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        Rectangle2D dataArea = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        double xx = plot.getDomainAxis().java2DToValue(p.getX(), dataArea, plot.getDomainAxisEdge());
        double yy = plot.getRangeAxis().java2DToValue(p.getY(), dataArea, plot.getRangeAxisEdge());
        double xxx = plot.getDomainAxis().valueToJava2D(xx, dataArea, plot.getDomainAxisEdge());
        double yyy = plot.getRangeAxis().valueToJava2D(yy, dataArea, plot.getRangeAxisEdge());
        Point p2 = this.chartPanel.translateJava2DToScreen(new Point2D.Double(xxx, yyy));
        System.out.println("Mouse coordinates are (" + x + ", " + y + "), in data space = (" + xx + ", " + yy + ").");
        System.out.println("--> (" + ((Point2D)p2).getX() + ", " + ((Point2D)p2).getY() + ")");
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    public static void main(String[] args) {
        ScatterPlotDemo3 demo = new ScatterPlotDemo3("Scatter Plot Demo 3");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

