/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class SecondaryDatasetDemo2
extends ApplicationFrame
implements ActionListener {
    private CategoryPlot plot;
    private int secondaryDatasetIndex = 0;

    public SecondaryDatasetDemo2(String title) {
        super(title);
        CategoryDataset dataset1 = this.createRandomDataset("Series 1");
        JFreeChart chart = ChartFactory.createLineChart("Secondary Dataset Demo 2", "Category", "Value", dataset1, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        this.plot = chart.getCategoryPlot();
        this.plot.setBackgroundPaint(Color.lightGray);
        this.plot.setDomainGridlinePaint(Color.white);
        this.plot.setRangeGridlinePaint(Color.white);
        this.plot.setAxisOffset(new Spacer(1, 4.0, 4.0, 4.0, 4.0));
        NumberAxis rangeAxis = (NumberAxis)this.plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        JPanel content = new JPanel(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(chart);
        content.add(chartPanel);
        JButton button1 = new JButton("Add Dataset");
        button1.setActionCommand("ADD_DATASET");
        button1.addActionListener(this);
        JButton button2 = new JButton("Remove Dataset");
        button2.setActionCommand("REMOVE_DATASET");
        button2.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(button1);
        buttonPanel.add(button2);
        content.add((Component)buttonPanel, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(content);
    }

    private CategoryDataset createRandomDataset(String name) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        double value = 100.0;
        int i = 0;
        while (i < 10) {
            String key = "T" + i;
            result.addValue(value *= 1.0 + Math.random() / 100.0, (Comparable)((Object)name), (Comparable)((Object)key));
            ++i;
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ADD_DATASET")) {
            if (this.secondaryDatasetIndex < 20) {
                ++this.secondaryDatasetIndex;
                this.plot.setDataset(this.secondaryDatasetIndex, this.createRandomDataset("S" + this.secondaryDatasetIndex));
                this.plot.setRenderer(this.secondaryDatasetIndex, new LineAndShapeRenderer(2));
            }
        } else if (e.getActionCommand().equals("REMOVE_DATASET") && this.secondaryDatasetIndex > 0) {
            this.plot.setDataset(this.secondaryDatasetIndex, null);
            this.plot.setRenderer(this.secondaryDatasetIndex, null);
            --this.secondaryDatasetIndex;
        }
    }

    public static void main(String[] args) {
        SecondaryDatasetDemo2 demo = new SecondaryDatasetDemo2("Secondary Dataset Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

