/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.data.HighLowDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SegmentedHighLowChartDemo
extends ApplicationFrame {
    public SegmentedHighLowChartDemo(String title, boolean useSegmentedAxis, int timelineType) {
        super(title);
        System.out.println("\nMaking SegmentedHighLowChartDemo(" + title + ")");
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        SegmentedTimeline timeline = null;
        switch (timelineType) {
            case 1: {
                timeline = SegmentedTimeline.newMondayThroughFridayTimeline();
                break;
            }
            case 2: {
                timeline = SegmentedTimeline.newFifteenMinuteTimeline();
                Calendar cal2 = (Calendar)cal.clone();
                cal2.add(1, 1);
                timeline.addBaseTimelineExclusions(cal.getTime().getTime(), cal2.getTime().getTime());
                break;
            }
            default: {
                System.out.println("Invalid timelineType.");
                System.exit(1);
            }
        }
        HighLowDataset dataset = DemoDatasetFactory.createSegmentedHighLowDataset(timeline, cal.getTime());
        JFreeChart chart = useSegmentedAxis ? ChartFactory.createHighLowChart(title, "Time", "Value", dataset, timeline, true) : ChartFactory.createHighLowChart(title, "Time", "Value", dataset, true);
        DateAxis axis = (DateAxis)chart.getXYPlot().getDomainAxis();
        axis.setAutoRange(true);
        TickUnits units = new TickUnits();
        units.add(new DateTickUnit(2, 1, 3, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 2, 3, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 7, 2, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 15, 2, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 30, 2, 1, new SimpleDateFormat("d-MMM")));
        axis.setStandardTickUnits(units);
        NumberAxis vaxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        vaxis.setAutoRangeIncludesZero(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        ApplicationFrame[][] frame = new ApplicationFrame[2][2];
        frame[0][0] = new SegmentedHighLowChartDemo("Segmented Daily High-Low-Open-Close Demo", true, 1);
        frame[1][0] = new SegmentedHighLowChartDemo("Normal Daily High-Low-Open-Close Demo", false, 1);
        frame[0][1] = new SegmentedHighLowChartDemo("Segmented Intraday High-Low-Open-Close Demo", true, 2);
        frame[1][1] = new SegmentedHighLowChartDemo("Normal Intraday High-Low-Open-Close Demo", false, 2);
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                frame[i][j].pack();
                RefineryUtilities.positionFrameOnScreen(frame[i][j], 0.15 + 0.7 * (double)j, 0.25 + 0.5 * (double)i);
                frame[i][j].setVisible(true);
                ++j;
            }
            ++i;
        }
    }
}

