/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SerializationTest1
extends ApplicationFrame
implements ActionListener {
    private TimeSeries series;
    private double lastValue = 100.0;
    static /* synthetic */ Class class$0;

    public SerializationTest1(String title) {
        super(title);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Millisecond");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.series = new TimeSeries("Random Data", clazz);
        TimeSeriesCollection dataset = new TimeSeriesCollection(this.series);
        JFreeChart chart = this.createChart(dataset);
        JFreeChart deserializedChart = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            chart = null;
            dataset = null;
            this.series = null;
            System.gc();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            deserializedChart = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TimeSeriesCollection c = (TimeSeriesCollection)deserializedChart.getXYPlot().getDataset();
        this.series = c.getSeries(0);
        ChartPanel chartPanel = new ChartPanel(deserializedChart);
        JButton button = new JButton("Add New Data Item");
        button.setActionCommand("ADD_DATA");
        button.addActionListener(this);
        JPanel content = new JPanel(new BorderLayout());
        content.add(chartPanel);
        content.add((Component)button, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(content);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart result = ChartFactory.createTimeSeriesChart("Serialization Test 1", "Time", "Value", dataset, true, true, false);
        XYPlot plot = result.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setFixedAutoRange(60000.0);
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ADD_DATA")) {
            double factor = 0.9 + 0.2 * Math.random();
            this.lastValue *= factor;
            Millisecond now = new Millisecond();
            System.out.println("Now = " + now.toString());
            this.series.add((RegularTimePeriod)new Millisecond(), this.lastValue);
        }
    }

    public static void main(String[] args) {
        SerializationTest1 demo = new SerializationTest1("Serialization Test 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

