/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import org.jfree.data.AbstractIntervalXYDataset;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.IntervalXYDataset;

public class SimpleIntervalXYDataset2
extends AbstractIntervalXYDataset
implements IntervalXYDataset {
    private Double[] yStart;
    private Double[] yEnd = new Double[3];
    private Double[] xValues = new Double[3];

    public SimpleIntervalXYDataset2(int itemCount) {
        this.xValues = new Double[itemCount];
        this.yStart = new Double[itemCount];
        this.yEnd = new Double[itemCount];
        double base = 100.0;
        int i = 1;
        while (i <= itemCount) {
            this.xValues[i - 1] = new Double(i);
            this.yStart[i - 1] = new Double(base *= 1.0 + (Math.random() / 10.0 - 0.05));
            this.yEnd[i - 1] = new Double(this.yStart[i - 1] + Math.random() * 30.0);
            ++i;
        }
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int series) {
        return "Series 1";
    }

    public int getItemCount(int series) {
        return this.xValues.length;
    }

    public Number getXValue(int series, int item) {
        return this.xValues[item];
    }

    public Number getYValue(int series, int item) {
        return this.yEnd[item];
    }

    public Number getStartXValue(int series, int item) {
        return this.xValues[item];
    }

    public Number getEndXValue(int series, int item) {
        return this.xValues[item];
    }

    public Number getStartYValue(int series, int item) {
        return this.yStart[item];
    }

    public Number getEndYValue(int series, int item) {
        return this.yEnd[item];
    }

    public void addChangeListener(DatasetChangeListener listener) {
    }

    public void removeChangeListener(DatasetChangeListener listener) {
    }
}

