/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StackedXYAreaRenderer;
import org.jfree.data.DefaultTableXYDataset;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYSeries;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedXYAreaChartDemo
extends ApplicationFrame {
    public StackedXYAreaChartDemo(String title) {
        super(title);
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
        XYSeries series1 = new XYSeries("Series 1", true, false);
        XYSeries series2 = new XYSeries("Series 2", true, false);
        XYSeries series3 = new XYSeries("Series 3", true, false);
        try {
            series1.add((double)sdf.parse("03-Jul-2003").getTime(), 115.0);
            series1.add((double)sdf.parse("04-Jul-2003").getTime(), 120.0);
            series1.add((double)sdf.parse("07-Jul-2003").getTime(), 125.0);
            series1.add((double)sdf.parse("08-Jul-2003").getTime(), 160.0);
            series1.add((double)sdf.parse("09-Jul-2003").getTime(), 175.0);
            series1.add((double)sdf.parse("10-Jul-2003").getTime(), 140.0);
            series1.add((double)sdf.parse("11-Jul-2003").getTime(), 145.0);
            series1.add((double)sdf.parse("14-Jul-2003").getTime(), 150.0);
            series1.add((double)sdf.parse("15-Jul-2003").getTime(), 155.0);
            series1.add((double)sdf.parse("16-Jul-2003").getTime(), 160.0);
            series1.add((double)sdf.parse("17-Jul-2003").getTime(), 165.0);
            series1.add((double)sdf.parse("18-Jul-2003").getTime(), 170.0);
            series2.add((double)sdf.parse("30-Jun-2003").getTime(), 50.0);
            series2.add((double)sdf.parse("01-Jul-2003").getTime(), 60.0);
            series2.add((double)sdf.parse("02-Jul-2003").getTime(), 70.0);
            series2.add((double)sdf.parse("03-Jul-2003").getTime(), 80.0);
            series2.add((double)sdf.parse("04-Jul-2003").getTime(), 90.0);
            series2.add((double)sdf.parse("07-Jul-2003").getTime(), 100.0);
            series2.add((double)sdf.parse("08-Jul-2003").getTime(), 110.0);
            series2.add((double)sdf.parse("09-Jul-2003").getTime(), 120.0);
            series2.add((double)sdf.parse("10-Jul-2003").getTime(), 130.0);
            series2.add((double)sdf.parse("11-Jul-2003").getTime(), 140.0);
            series2.add((double)sdf.parse("14-Jul-2003").getTime(), 150.0);
            series2.add((double)sdf.parse("15-Jul-2003").getTime(), 160.0);
            series2.add((double)sdf.parse("16-Jul-2003").getTime(), 170.0);
            series2.add((double)sdf.parse("17-Jul-2003").getTime(), 180.0);
            series2.add((double)sdf.parse("18-Jul-2003").getTime(), 190.0);
            series3.add((double)sdf.parse("30-Jun-2003").getTime(), 100.0);
            series3.add((double)sdf.parse("01-Jul-2003").getTime(), 120.0);
            series3.add((double)sdf.parse("02-Jul-2003").getTime(), 110.0);
            series3.add((double)sdf.parse("03-Jul-2003").getTime(), 120.0);
            series3.add((double)sdf.parse("04-Jul-2003").getTime(), 130.0);
            series3.add((double)sdf.parse("07-Jul-2003").getTime(), 135.0);
            series3.add((double)sdf.parse("08-Jul-2003").getTime(), 140.0);
            series3.add((double)sdf.parse("09-Jul-2003").getTime(), 155.0);
            series3.add((double)sdf.parse("10-Jul-2003").getTime(), 130.0);
            series3.add((double)sdf.parse("11-Jul-2003").getTime(), 135.0);
            series3.add((double)sdf.parse("14-Jul-2003").getTime(), 140.0);
            series3.add((double)sdf.parse("15-Jul-2003").getTime(), 165.0);
            series3.add((double)sdf.parse("16-Jul-2003").getTime(), 170.0);
            series3.add((double)sdf.parse("17-Jul-2003").getTime(), 165.0);
            series3.add((double)sdf.parse("18-Jul-2003").getTime(), 140.0);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        dataset.addSeries(series3);
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(TableXYDataset dataset) {
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("dd-MMM-yyyy", Locale.UK), NumberFormat.getInstance());
        DateAxis xAxis = new DateAxis("Domain (X)");
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        NumberAxis yAxis = new NumberAxis("Range (Y)");
        yAxis.setAutoRangeIncludesZero(true);
        StackedXYAreaRenderer renderer = new StackedXYAreaRenderer(5, toolTipGenerator, null);
        renderer.setOutline(true);
        renderer.setSeriesPaint(0, new Color(255, 255, 206));
        renderer.setSeriesPaint(1, new Color(206, 230, 255));
        renderer.setSeriesPaint(2, new Color(255, 230, 230));
        renderer.setShapePaint(Color.gray);
        renderer.setShapeStroke(new BasicStroke(0.5f));
        renderer.setShape(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        return chart;
    }

    public static void main(String[] args) {
        StackedXYAreaChartDemo demo = new StackedXYAreaChartDemo("Stacked Area XY Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

